% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{upload_truth}
\alias{upload_truth}
\title{Upload truth data}
\usage{
upload_truth(zoltar_connection, project_url, truth_csv_file, issued_at = NULL)
}
\arguments{
\item{zoltar_connection}{A \code{ZoltarConnection} object as returned by \code{\link[=new_connection]{new_connection()}}}

\item{project_url}{URL of a project in zoltar_connection's projects}

\item{truth_csv_file}{A CSV file as documented at https://docs.zoltardata.com/fileformats/#truth-data-format-csv}

\item{issued_at}{optional datetime to use for the uploaded truth forecasts' issued_at value in ISO 8601 format. NB:
it must include timezone information. (the default issued_at is the time of upload.) the value must obey the
constraints documented at https://docs.zoltardata.com/forecastversions/#forecast-version-rules}
}
\value{
A Job URL for the upload
}
\description{
Uploads the data in truth_csv_file to the project identified by project_url.
}
\examples{
\dontrun{
  job_url <- upload_truth(conn, "http://www.zoltardata.com/api/project/1/", "truth.csv")
}

}
