% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlog.R
\name{z}
\alias{z}
\alias{zlog}
\title{Calculate z/zlog Values}
\usage{
z(x, limits, probs = c(0.025, 0.975), log = FALSE)

zlog(x, limits, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{\code{numeric}, laboratory values.}

\item{limits}{\code{numeric} or \code{matrix}, lower and upper reference limits. Has to
be of length 2 for \code{numeric} or a two-column \code{matrix} with as many rows as
elements in \code{x}.}

\item{probs}{\code{numeric}, probabilities of the lower and upper reference limit,
default: \code{c(0.025, 0.975)} (spanning 95 \%). Has to be of length 2 for
\code{numeric} or a two-column \code{matrix} with as many rows as elements in \code{x}.}

\item{log}{\code{logical}, should z (\code{log = FALSE}, default) or
z(log) (\code{log = TRUE}) calculated?}
}
\value{
\code{numeric}, z or z(log) values.
}
\description{
Calculates the z or z(log) values for laboratory measurement standardisation
as proposed in Hoffmann 2017 et al.
}
\details{
The z value is calculated as follows (assuming that the limits where 0.025
and 0.975 quantiles):
\eqn{z = (x - (limits_1 + limits_2 )/2) * 3.92/(limits_2 - limits_1)}.

The z(log) value is calculated as follows (assuming that the limits where 0.025
and 0.975 quantiles):
\eqn{z = (\log(x) - (\log(limits_1) + \log(limits_2))/2) * 3.92/(\log(limits_2) - \log(limits_1))}.

\code{zlog} is an alias for \code{z(..., log = TRUE)}.
}
\examples{
z(1:10, limits = c(2, 8))

# from Hoffmann et al. 2017
albumin <- c(42, 34, 38, 43, 50, 42, 27, 31, 24)
zlog(albumin, limits = c(35, 52))

bilirubin <- c(11, 9, 2, 5, 22, 42, 37, 200, 20)

limits <- cbind(
    lower = rep(c(35, 2), c(length(albumin), length(bilirubin))),
    upper = rep(c(52, 21), c(length(albumin), length(bilirubin)))
)
zlog(c(albumin, bilirubin), limits = limits)
}
\references{
Georg Hoffmann, Frank Klawonn, Ralf Lichtinghagen, and Matthias Orth.
2017.
"The Zlog-Value as Basis for the Standardization of Laboratory Results."
LaboratoriumsMedizin 41 (1): 23–32.
\doi{10.1515/labmed-2016-0087}.
}
\seealso{
\code{\link[=izlog]{izlog()}}
}
\author{
Sebastian Gibb
}
