% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot1dloon.R
\name{density_1d_loon}
\alias{density_1d_loon}
\title{Density plot in 1d using the interactive loon package}
\usage{
density_1d_loon(zargs, density.args = list(), method = c("single",
  "double"), lwd = NULL, linewidth = NULL, color = NULL,
  fill = NULL, linecolor = NULL, linkingGroup = NULL,
  showLabels = FALSE, showScales = FALSE, showGuides = FALSE,
  baseplot = NULL, parent = NULL, ...)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{density.args}{A list of arguments for density()}

\item{method}{A character specifying the type of density used}

\item{lwd}{Line width  used only when linewidth = NULL, value of 1 used
otherwise.}

\item{linewidth}{Line width of outline for density polygons (highest
priority)}

\item{color}{Colour used to fill the density when fill is NULL and to
outline the density when linecolor is NULL, foreground colour used
otherwise.}

\item{fill}{Colour used to fill the density polygon}

\item{linecolor}{Colour used for the outline of the density}

\item{linkingGroup}{A string specifying the initial group of plots to be
linked to this plot}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines are
displayed}

\item{baseplot}{If non-null the base plot on which the plot should be
layered}

\item{parent}{The tk parent for this loon plot widget}

\item{...}{Additional parameters passed to loon::l_layer()}
}
\value{
A loon loon::l_plot(...)
}
\description{
Density plot in 1d using the interactive loon package
}
\seealso{
Other default 1d plot functions using the interactive loon package: \code{\link{arrow_1d_loon}},
  \code{\link{boxplot_1d_loon}},
  \code{\link{hist_1d_loon}}, \code{\link{jitter_1d_loon}},
  \code{\link{label_1d_loon}}, \code{\link{lines_1d_loon}},
  \code{\link{points_1d_loon}}, \code{\link{rect_1d_loon}},
  \code{\link{rug_1d_loon}}

Other default 1d plot functions: \code{\link{arrow_1d_graphics}},
  \code{\link{arrow_1d_grid}}, \code{\link{arrow_1d_loon}},
  \code{\link{boxplot_1d_graphics}},
  \code{\link{boxplot_1d_grid}},
  \code{\link{boxplot_1d_loon}},
  \code{\link{density_1d_graphics}},
  \code{\link{density_1d_grid}}, \code{\link{extract_1d}},
  \code{\link{hist_1d_graphics}},
  \code{\link{hist_1d_grid}}, \code{\link{hist_1d_loon}},
  \code{\link{jitter_1d_graphics}},
  \code{\link{jitter_1d_grid}},
  \code{\link{jitter_1d_loon}},
  \code{\link{label_1d_graphics}},
  \code{\link{label_1d_grid}}, \code{\link{label_1d_loon}},
  \code{\link{lines_1d_graphics}},
  \code{\link{lines_1d_grid}}, \code{\link{lines_1d_loon}},
  \code{\link{points_1d_graphics}},
  \code{\link{points_1d_grid}},
  \code{\link{points_1d_loon}},
  \code{\link{rect_1d_graphics}},
  \code{\link{rect_1d_grid}}, \code{\link{rect_1d_loon}},
  \code{\link{rug_1d_graphics}}, \code{\link{rug_1d_grid}},
  \code{\link{rug_1d_loon}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 1d plot functions}
\concept{default 1d plot functions using the interactive loon package}
