# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

compute_observed_probability <- function(x, number_of_samples, number_of_dims, number_of_cells, number_of_levels) {
    .Call('_zebu_compute_observed_probability', PACKAGE = 'zebu', x, number_of_samples, number_of_dims, number_of_cells, number_of_levels)
}

compute_expected_probability <- function(margins) {
    .Call('_zebu_compute_expected_probability', PACKAGE = 'zebu', margins)
}

compute_marginal_probability <- function(x, number_of_samples, number_of_dims, number_of_cells, number_of_levels) {
    .Call('_zebu_compute_marginal_probability', PACKAGE = 'zebu', x, number_of_samples, number_of_dims, number_of_cells, number_of_levels)
}

#' Estimate marginal and multivariate probabilities
#'
#' Maximum-likelihood estimation of marginal and multivariate observed and expected independence probabilities. Marginal probability refers to probability of each factor per individual column. Multivariate probability refer to cross-classifying factors for all columns.
#'
#' @param x data.frame or matrix.
#'
#' @return List containing the following values:
#'   \itemize{
#'   \item margins: a list of marginal probabilities. Names correspond to colnames(x).
#'   \item observed: observed multivariate probability array.
#'   \item expected: expected multivariate probability array
#'   }
#'
#' @example /inst/examples/lassie.R
#'
#' @export
estimate_prob <- function(x) {
    .Call('_zebu_estimate_prob', PACKAGE = 'zebu', x)
}

#' @title Local Association Measures
#'
#' @description Subroutines called by \code{\link[zebu]{lassie}} to compute
#' local and global association measures from a list of probabilities.
#'
#' @param x list of probabilities as outputted by \code{\link[zebu]{estimate_prob}}.
#' @param measure name of measure to be used:
#' \itemize{
#' \item'chisq': Chi-squared residuals.
#' \item'd': Lewontin's D.
#' \item'z': Ducher's 'z'.
#' \item'pmi': Pointwise mutual information (in bits).
#' \item'npmi': Normalized pointwise mutual information (Bouma).
#' \item'npmi2': Normalized pointwise mutual information (Multivariate).
#' }
#' @param nr number of rows/samples. Only used to estimate chi-squared residuals.
#'
#' @return List containing the following values:
#' \itemize{
#' \item local: local association array (may contain NA, NaN and Inf values).
#' \item global: global association numeric value.
#' }
#'
#'
#' @seealso \code{\link[zebu]{lassie}}
#'
#' @example /inst/examples/lassie.R
#'
#' @name local_association
#'
#' @export
local_association <- function(x, measure = "chisq", nr = 1) {
    .Call('_zebu_local_association', PACKAGE = 'zebu', x, measure, nr)
}

#' @rdname local_association
#' @export
lewontin_d <- function(x) {
    .Call('_zebu_lewontin_d', PACKAGE = 'zebu', x)
}

#' @rdname local_association
#' @export
duchers_z <- function(x) {
    .Call('_zebu_duchers_z', PACKAGE = 'zebu', x)
}

#' @rdname local_association
#' @param normalize 0 for pmi, 1 for npmi, 2 for npmi2
#' @export
pmi <- function(x, normalize) {
    .Call('_zebu_pmi', PACKAGE = 'zebu', x, normalize)
}

#' @rdname local_association
#' @export
chisq <- function(x, nr) {
    .Call('_zebu_chisq', PACKAGE = 'zebu', x, nr)
}

permute_dataframe <- function(x, group) {
    .Call('_zebu_permute_dataframe', PACKAGE = 'zebu', x, group)
}

permtest_rcpp <- function(x, nb, group) {
    .Call('_zebu_permtest_rcpp', PACKAGE = 'zebu', x, nb, group)
}

