% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBatsmenVsBowlersAllOppnAllMatchesRept.R
\name{teamBatsmenVsBowlersAllOppnAllMatchesRept}
\alias{teamBatsmenVsBowlersAllOppnAllMatchesRept}
\title{Report of team batsmen vs bowlers in all matches all oppositions}
\usage{
teamBatsmenVsBowlersAllOppnAllMatchesRept(matches,theTeam,rank=0,dispRows=50)
}
\arguments{
\item{matches}{All the matches of the team against all oppositions}

\item{theTeam}{The team for which the the batting partnerships are sought}

\item{rank}{if the rank=0  then the data frame returned gives a summary list of the batsmen with the highest
runs against bowlers. If rank=N (where N=1,2,3...) then the detailed breakup of the batsman and the runs
scored against each bowler is returned}

\item{dispRows}{The number of rows to be returned}
}
\value{
h
The data frame of the batsman and the runs against bowlers
}
\description{
This function computes the performance of batsmen against all bowlers of all oppositions in all matches
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches for team India against all oppositions
m <-teamBattingScorecardAllOppnAllMatches(matches,theTeam="India")
# Get the  summary report
teamBatsmenVsBowlersAllOppnAllMatchesRept(matches,"India",rank=0)
#Get detailed report
teamBatsmenVsBowlersAllOppnAllMatchesRept(matches,"India",rank=1,dispRows=50)

teamBatsmenVsBowlersAllOppnAllMatchesRept(matches,"Pakistan",rank=0)
teamBatsmenVsBowlersAllOppnAllMatchesRept(matches,"England",rank=1)
}

}
\author{
Tinniam V Ganesh
}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenVsBowlersOppnAllMatches}}\cr
}

