% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yhatR.R
\name{yhat.predict_bulk}
\alias{yhat.predict_bulk}
\title{Make bulk predictions using Yhat.}
\usage{
yhat.predict_bulk(model_name, data, model_owner, raw_input = FALSE,
  silent = TRUE)
}
\arguments{
\item{model_name}{the name of the model you want to call}

\item{data}{input rows of data to be scored}

\item{model_owner}{the owner of the model [optional]}

\item{raw_input}{when true, incoming data will NOT be coerced into data.frame}

\item{silent}{should output of url to console (via \code{yhat.post})
be silenced? Default is \code{FALSE}.}
}
\description{
This function calls Yhat's bulk API and returns a response formatted as a
data frame.
}
\examples{
yhat.config <- c(
 username = "your username",
 apikey = "your apikey",
 env = "http://sandbox.yhathq.com/"
)
\dontrun{
yhat.predict_bulk("irisModel", iris)
}
}
\keyword{bulk}

