% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{create_query}
\alias{create_query}
\title{Create a Structured Query for the Yahoo Finance API}
\usage{
create_query(filters = list("eq", list("region", "us")),
  top_operator = "and")
}
\arguments{
\item{filters}{list. Each element is a sublist that defines a filtering condition with
the following structure:
\describe{
  \item{\code{comparison}}{string. Comparison operator (i.e., "gt", "lt", "eq", "btwn").}
  \item{\code{field}}{list. Field name (e.g. "region") and its associated value(s).}
}}

\item{top_operator}{string. Top-level logical operator to combine all filters (i.e., "and", "or").}
}
\value{
A nested list representing the structured query with logical operations and
nested conditions formatted for the Yahoo Finance API.
}
\description{
A function to create a structured query with logical operations and nested conditions
formatted for the Yahoo Finance API.
}
\examples{
filters <- list(
  list("eq", list("region", "us")),
  list("btwn", list("intradaymarketcap", 2000000000, 10000000000)),
  list("btwn", list("intradaymarketcap", 10000000000, 100000000000)),
  list("gt", list("intradaymarketcap", 100000000000)),
  list("gt", list("dayvolume", 5000000))
)

query <- create_query(filters)
}
