% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-iic.R
\name{iic}
\alias{iic}
\alias{iic.data.frame}
\alias{iic_vec}
\title{Index of ideality of correlation}
\usage{
iic(data, ...)

\method{iic}{data.frame}(data, truth, estimate, na_rm = TRUE, ...)

iic_vec(truth, estimate, na_rm = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{iic_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Calculate the index of ideality of correlation. This metric has been
studied in QSPR/QSAR models as a good criterion for the predictive
potential of these models. It is highly dependent on the correlation
coefficient as well as the mean absolute error.

Note the application of IIC is useless under two conditions:
\itemize{
\item When the negative mean absolute error and positive mean absolute
error are both zero.
\item When the outliers are symmetric. Since outliers are context
dependent, please use your own checks to validate whether this
restriction holds and whether the resulting IIC has
interpretative value.
}

The IIC is seen as an alternative to the traditional correlation
coefficient and is in the same units as the original data.
}
\examples{
# Supply truth and predictions as bare column names
iic(solubility_test, solubility, prediction)

library(dplyr)

set.seed(1234)
size <- 100
times <- 10

# create 10 resamples
solubility_resampled <- bind_rows(
  replicate(
    n = times,
    expr = sample_n(solubility_test, size, replace = TRUE),
    simplify = FALSE
  ),
  .id = "resample"
)

# Compute the metric by group
metric_results <- solubility_resampled \%>\%
  group_by(resample) \%>\%
  iic(solubility, prediction)

metric_results

# Resampled mean estimate
metric_results \%>\%
  summarise(avg_estimate = mean(.estimate))
}
\references{
Toropova, A. and Toropov, A. (2017). "The index of ideality
of correlation. A criterion of predictability of QSAR models for skin
permeability?" \emph{Science of the Total Environment}. 586: 466-472.
}
\seealso{
Other numeric metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{rmse}()},
\code{\link{rpd}()},
\code{\link{rpiq}()},
\code{\link{rsq_trad}()},
\code{\link{rsq}()},
\code{\link{smape}()}

Other accuracy metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{rmse}()},
\code{\link{smape}()}
}
\author{
Joyce Cahoon
}
\concept{accuracy metrics}
\concept{numeric metrics}
