% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBbox.R
\name{getBbox}
\alias{getBbox}
\title{Get a standard bounding box to impose spatial constraints}
\usage{
getBbox(hydros, buffer = 5, eps = 0.001, pen = 1)
}
\arguments{
\item{hydros}{Dataframe from simHydros() or Dataframe with columns hx and hy containing positions of the receivers. Translate the coordinates to get the grid centre close to (0;0).}

\item{buffer}{Number of meters the spatial domain extends beyound the outer hydros.}

\item{eps}{Specifies how well-defined the borders are (eps=1E-2 is very sharp, eps=100 is very soft).}

\item{pen}{Specifies the penalty multiplier.}
}
\value{
Vector of lenght 6: c(x_min, x_max, y_min, y_max, eps, pen). Limits are given in UTM coordinates.
}
\description{
Standard is a rectangle based on coordinates of outer hydros +- the buffer in meters
}
\examples{
hydros <- ssu1$hydros
colnames(hydros) <- c('serial','hx','hy','hz','sync_tag','idx')
bbox <- getBbox(hydros)
plotBbox(hydros, bbox)
}
