% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate.R
\name{decorate.character}
\alias{decorate.character}
\title{Decorate Character}
\usage{
\method{decorate}{character}(
  x,
  meta = NULL,
  ...,
  read = getOption("yamlet_import", as.csv),
  ext = getOption("yamlet_extension", ".yaml")
)
}
\arguments{
\item{x}{file path for table data}

\item{meta}{file path for corresponding yamlet metadata, or a yamlet object}

\item{...}{passed to \code{read} (if accepted) and to \code{\link{as_yamlet.character}}}

\item{read}{function or function name for reading x}

\item{ext}{file extension for metadata file, if relevant}
}
\value{
class 'decorated' 'data.frame'
}
\description{
Treats \code{x} as a file path. By default,
metadata is sought from a file with the same
base but the 'yaml' extension.
}
\examples{

# find data file
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
file

# find metadata file
meta <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
meta

# decorate with explicit metadata reference
a <- decorate(file, meta)

# rely on default metadata path
b <- decorate(file)

# in this case: same
stopifnot(identical(a, b))
}
\seealso{
Other decorate: 
\code{\link{as_decorated.default}()},
\code{\link{as_decorated}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorate}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations}()},
\code{\link{redecorate}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{decorate}
\concept{interface}
