% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xvardef.R
\name{xvardef}
\alias{xvardef}
\alias{xvardef<-}
\title{Extracts and set Xpose variable definitions.}
\usage{
xvardef(x, object)

xvardef(object) <- value
}
\arguments{
\item{x}{The name of an xpose variable (see below).}

\item{object}{An \code{xpose.data} object.}

\item{value}{A two element vector of which the first element is the name of
the variable and the second the column name in the Data slot of the object.}
}
\value{
Returns a string with the name of the data variable defined as the
Xpose data variable.
}
\description{
This function extracts and set Xpose variable definitions in "xpose.data"
objects.
}
\details{
The Xpose variable definitions are used to map particular variable types to
column names in the data.frame in the Data slot of the "xpose.data" object.
The single-valued Xpose variable definitions are: \code{id, idlab, idv, occ,
dv, pred, ipred, iwres, res}. The (potentially) vector-valued Xpose variable
definitions are: \code{parms, covariates, ranpar, tvparms} (parameters,
covariates, random effects parameters=etas, typical value parameters). The
default values of these can be found in the \code{createXposeClasses}
function.
}
\section{Functions}{
\itemize{
\item \code{xvardef<-}: reset the which column the label dv points to in the Data slot of
the xpose database object
}}

\examples{
xpdb <- simpraz.xpdb

## get the column name in the Data slot of object xpdb
## corresponding to the label dv
xvardef("dv", xpdb)

## reset the which column the label dv points to in the Data slot of
## object xpdb
xvardef(xpdb) <- c("dv", "DVA")

}
\seealso{
\code{\link{xpose.data-class}},\code{\link{xpose.prefs-class}}
}
\author{
Niclas Jonsson
}
