% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.summary.R, R/parm.summary.R
\name{par_cov_summary}
\alias{par_cov_summary}
\alias{cov.summary}
\alias{parm.summary}
\title{Summarize individual parameter values and covariates}
\usage{
cov.summary(object, onlyfirst = TRUE, subset = xsubset(object),
  inclZeroWRES = FALSE, out.file = ".screen", main = "Default",
  fill = "gray", values.to.use = xvardef("covariates", object),
  value.name = "Covariate", ...)

parm.summary(object, onlyfirst = TRUE, subset = xsubset(object),
  inclZeroWRES = FALSE, out.file = ".screen", main = "Default",
  fill = "gray", values.to.use = xvardef("parms", object),
  value.name = "Parameter", max.plots.per.page = 1, ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{onlyfirst}{Logical value indicating if only the first row per
individual is included in the plot.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 are
included in the plot. The default is FALSE.}

\item{out.file}{Where the results should be output to.  Can be ".screen",
".ask", ".graph" or a filename in quotes.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{fill}{The color to fill the boxes in the table if the table is printed
to ".graph"}

\item{values.to.use}{Which values should be summarized}

\item{value.name}{The name of the values}

\item{\dots}{Other arguments passed to \code{Data} and \code{SData}.}

\item{max.plots.per.page}{Maximum plots per page.}
}
\value{
Returned is the matrix of values from the table. \code{parm.summary}
and \code{cov.summary} produce summaries of parameters and covariates,
respectively. \code{parm.summary} produces less attractive output but
supports mirror functionality.

\code{parm.summary} and \code{cov.summary} utilize
\code{\link[Hmisc]{print.char.matrix}} to print the information to the
screen.
}
\description{
These functions produce tables, printed to the screen, summarizing the
individual parameter values or covariates from a dataset in Xpose 4.
}
\section{Functions}{
\itemize{
\item \code{cov.summary}: Covariate summary

\item \code{parm.summary}: Parameter summary
}}

\examples{
## Here we load the example xpose database 
xpdb <- simpraz.xpdb

parm.summary(xpdb)

cov.summary(xpdb)

}
\seealso{
\code{\link{Data}}, \code{\link{SData}},
\code{\link{xpose.data-class}}, \code{\link[Hmisc]{print.char.matrix}}

Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{change_misc_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{data_extract_or_assign}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{import.variable.definitions}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{simprazExample}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.data}}, \code{\link{xpose.print}},
  \code{\link{xpose4-package}}, \code{\link{xsubset}}
}
\author{
Andrew Hooker & Justin Wilkins
}
\keyword{methods}
