% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootscm.R
\name{bootscm.import}
\alias{bootscm.import}
\title{Import bootscm data into R/Xpose}
\usage{
bootscm.import(scm.folder = NULL, silent = FALSE, n.bs = NULL,
  cov.recoding = NULL, group.by.cov = NULL, skip.par.est.import = FALSE,
  dofv.forward = 3.84, dofv.backward = 6.64, runno = NULL,
  return.obj = FALSE)
}
\arguments{
\item{scm.folder}{The folder in which the PsN-generated bootscm data are.}

\item{silent}{Don't output any progress report. Default is FALSE.}

\item{n.bs}{The number of bootstraps performed. Defaults to 100.}

\item{cov.recoding}{For categorical covariates that are recoded to
dichotomous covariates within the bootscm configuration file, a list can be
specified containing data frames for recoding. See the example below for
details.}

\item{group.by.cov}{Group inclusion frequencies by covariate, instead of
calculating them per parameter-covariates relationship. Default is NULL,
which means that the user will be asked to make a choice.}

\item{skip.par.est.import}{Skip the import of all parameter estimates (in
each final model in all scm's, as well as parameter estimates in first step
of each scm). These data are required to make plot that show inclusion bias
and correlation in parameter estimates. Importing these data takes a bit of
time (may take a minute or so), so if you don't intend to make these plots
anyhow this step can be skipped. Default is FALSE.}

\item{dofv.forward}{dOFV value used in forward step of scm.}

\item{dofv.backward}{dOFV value used in backward step of scm.}

\item{runno}{The run-number of the base model for this bootSCM.}

\item{return.obj}{Should the bootscm object be returned by the function?}
}
\description{
This function imports data generated by the PsN boot_scm function into the
Xpose / R environment.
}
\seealso{
Other bootscm: \code{\link{xp.daic.npar.plot}},
  \code{\link{xp.dofv.npar.plot}},
  \code{\link{xp.inc.cond.stab.cov}},
  \code{\link{xp.inc.ind.cond.stab.cov}},
  \code{\link{xp.inc.stab.cov}},
  \code{\link{xp.incl.index.cov.ind}},
  \code{\link{xp.incl.index.cov}}

Other PsN functions: \code{\link{boot.hist}},
  \code{\link{npc.coverage}}, \code{\link{randtest.hist}},
  \code{\link{read.npc.vpc.results}},
  \code{\link{read.vpctab}}, \code{\link{xpose.VPC.both}},
  \code{\link{xpose.VPC.categorical}},
  \code{\link{xpose.VPC}}, \code{\link{xpose4-package}}
}
\author{
Ron Keizer
}
