% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vpc.R
\name{vpc}
\alias{vpc}
\title{Visual predictive checks}
\usage{
vpc(xpdb, vpc_type = NULL, mapping = NULL, smooth = TRUE,
  type = "alpr", title = "Visual predictive checks | @run",
  subtitle = "Number of simulations: @vpcnsim, confidence interval: @vpcci\%",
  caption = "@vpcdir", tag = NULL, log = NULL, guide = TRUE,
  gg_theme, xp_theme, facets, quiet, area_fill = c("steelblue3",
  "grey60", "steelblue3"), line_linetype = c("93", "solid", "93"), ...)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{vpc_type}{Only used when multiple vpc data are present in the same xpdb. The type of 
vpc to be created. Can be one of can be one of: 'continuous', 'categorical', 
'censored' or 'time-to-event'.}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot 
(e.g. \code{point_color}).}

\item{smooth}{Should the bins be smoothed (connect bin midpoints, default) or shown as rectangular boxes.}

\item{type}{String setting the type of plot to be used. Can be points 'p',
line 'l', area 'a', rug 'r' and text 't' or any combination of the five.}

\item{title}{Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Page caption. Use \code{NULL} to remove.}

\item{tag}{Plot identification tag. Use \code{NULL} to remove.}

\item{log}{String assigning logarithmic scale to axes, can be either '', 
'x', y' or 'xy'.}

\item{guide}{Enable guide display in vpc continuous (e.g. lloq and uloq lines).}

\item{gg_theme}{A complete ggplot2 theme object (e.g.
\code{\link[ggplot2]{theme_classic}}), a function returning a complete
ggplot2 theme, or a change to the current \code{gg_theme}.}

\item{xp_theme}{A complete xpose theme object (e.g.
\code{\link{theme_xp_default}}) or a list of modifications to the current
\code{xp_theme} (e.g. \code{list(point_color = 'red', line_linetype =
'dashed')}).}

\item{facets}{Either a character string to use \link[ggplot2]{facet_wrap} 
or a formula to use \link[ggplot2]{facet_grid}.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{area_fill}{Shaded areas filling color, should be a vector of 3 values (i.e. low, med, high).}

\item{line_linetype}{Lines linetype, should be a vector of 3 values (i.e. low, med, high).}

\item{...}{any additional aesthetics.}
}
\description{
Generate visual predictive checks (VPC)
}
\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is 
layer_option where layer is one of the names defined in the list below and option is 
any option supported by this layer e.g. point_color = 'blue', area_fill = 'green', etc.
\itemize{
  \item point: options to \code{geom_point}
  \item line: options to \code{geom_line}
  \item area: options to \code{geom_ribbon} (smooth = TRUE) or \code{geom_rect} (smooth = FALSE)
  \item rug: options to \code{geom_rug}
  \item text: options to \code{geom_text}
  \item guide: options to \code{geom_hline}
  \item xscale: options to \code{scale_x_continuous} or \code{scale_x_log10}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\section{Faceting}{

Every xpose plot function has built-in faceting functionalities. Faceting arguments 
are passed to the functions \code{\link[ggforce]{facet_wrap_paginate}} when the \code{facets} 
argument is a character string (e.g. \code{facets = c('SEX', 'MED1')}) or 
\code{\link[ggforce]{facet_grid_paginate}} when facets is a formula (e.g. \code{facets = SEX~MED1}).
All xpose plot functions accept all the arguments for the \code{\link[ggforce]{facet_wrap_paginate}} 
and \code{\link[ggforce]{facet_grid_paginate}} functions e.g. \code{dv_vs_ipred(xpdb_ex_pk, 
facets = SEX~MED1, ncol = 3, nrow = 3, page = 1, margins = TRUE, labeller = 'label_both')}.

Faceting options can either be defined in plot functions (e.g. \code{dv_vs_ipred(xpdb_ex_pk, 
facets = 'SEX')}) or assigned globally to an xpdb object via the \code{xp_theme} (e.g. \code{xpdb 
<- update_themes(xpdb_ex_pk, xp_theme = list(facets = 'SEX'))}). In the latter example all plots 
generate from this xpdb will automatically be stratified by `SEX`.

By default, some plot functions use a custom stratifying variable named `variable`, e.g. 
\code{eta_distrib()}. When using the \code{facets} argument, `variable` needs to be added manually 
e.g. \code{facets = c('SEX', 'variable')} or \code{facets = c('SEX', 'variable')}, but is optional, 
when using the \code{facets} argument in \code{xp_theme} variable is automatically added whenever needed.
}

\section{Template titles}{

Template titles can be used to create highly informative diagnostics plots. 
They can be applied to any plot title, subtitle, caption and tag. Template titles 
are defined via a single string containing key variables staring with a `@` (e.g. `@ofv`)
which will be replaced by their actual value when rendering the plot.
For example `'@run, @nobs observations in @nind subjects'` would become 
`'run001, 1022 observations in 74 subjects'`. The available key variables 
are listed under \code{\link{template_titles}}.
}

\examples{
xpdb_ex_pk \%>\% 
 vpc_data(opt = vpc_opt(n_bins = 7)) \%>\% 
 vpc()
}
\seealso{
\code{\link{vpc_data}}
}
