% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_label.R
\name{xportr_df_label}
\alias{xportr_df_label}
\title{Assign Dataset Label}
\usage{
xportr_df_label(.df, metadata = NULL, domain = NULL, metacore = deprecated())
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metadata}{A data frame containing dataset. See 'Metadata' section for
details.}

\item{domain}{Appropriate CDSIC dataset name, e.g. ADAE, DM. Used to subset
the metadata object. If none is passed, then name of the dataset passed as
.df will be used.}

\item{metacore}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Previously used to pass
metadata now renamed with \code{metadata}}
}
\value{
Data frame with label attributes.
}
\description{
Assigns dataset label from a dataset level metadata to a given data frame.
This is stored in the 'label' attribute of the dataframe.
}
\section{Metadata}{
 The argument passed in the 'metadata' argument can either
be a metacore object, or a data.frame containing the data listed below. If
metacore is used, no changes to options are required.

For data.frame 'metadata' arguments two columns must be present:
\enumerate{
\item Domain Name - passed as the 'xportr.df_domain_name' option. Default:
"dataset". This is the column subset by the 'domain' argument in the
function.
\item Label Name - passed as the 'xportr.df_label' option. Default:
"label". Character values to update the 'label' attribute of the
dataframe This is passed to \code{haven::write_xpt} to note the label.
}
}

\examples{
adsl <- data.frame(
  USUBJID = c(1001, 1002, 1003),
  SITEID = c(001, 002, 003),
  AGE = c(63, 35, 27),
  SEX = c("M", "F", "M")
)

metadata <- data.frame(
  dataset = c("adsl", "adae"),
  label = c("Subject-Level Analysis", "Adverse Events Analysis")
)

adsl <- xportr_df_label(adsl, metadata)
}
