library(xpectr)
context("assertCollectionAddin()")

# assertCollectionAddin <- function(add_comments = TRUE, insert = TRUE, indentation = NULL)


test_that("testing assertCollectionAddin()", {

  xpectr::set_test_seed(42)
  # gxs_function(assertCollectionAddin, args_values = list(
  #   "add_comments" = list(TRUE, FALSE, NA, 1),
  #   "insert" = list(FALSE, NA, 0),
  #   "indentation" = list(0, 3, -3, NA)
  # ), indentation = 2)


  ## Testing 'assertCollectionAddin'                                          ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- assertCollectionAddin(add_comments = TRUE, insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_19148),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "character")
  # Testing values
  expect_equal(
    output_19148,
    c("# Check arguments ####", "assert_collection <- checkmate::makeAssertCollection()",
      "# checkmate::assert_ , add = assert_collection)", "checkmate::reportAssertions(assert_collection)",
      "# End of argument checks ####"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    5L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    5L)

  # Testing assertCollectionAddin(add_comments = FALSE, ...
  # Changed from baseline: add_comments = FALSE
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- assertCollectionAddin(add_comments = FALSE, insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_19370),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "character")
  # Testing values
  expect_equal(
    output_19370,
    c("assert_collection <- checkmate::makeAssertCollection()", "# checkmate::assert_ , add = assert_collection)",
      "checkmate::reportAssertions(assert_collection)"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    3L)

  # Testing assertCollectionAddin(add_comments = NA, ins...
  # Changed from baseline: add_comments = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = NA, insert = FALSE, indentation = 0)),
    xpectr::strip("1 assertions failed:\n * Variable 'add_comments': May not be NA."),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = 1, inse...
  # Changed from baseline: add_comments = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = 1, insert = FALSE, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'add_comments': Must be o",
                         "f type 'logical flag', not 'double'.")),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = NULL, i...
  # Changed from baseline: add_comments = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = NULL, insert = FALSE, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'add_comments': Must be o",
                         "f type 'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: insert = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = TRUE, insert = NA, indentation = 0)),
    xpectr::strip("1 assertions failed:\n * Variable 'insert': May not be NA."),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: insert = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = TRUE, insert = 0, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'insert': Must be of type",
                         " 'logical flag', not 'double'.")),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: insert = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = TRUE, insert = NULL, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'insert': Must be of type",
                         " 'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: indentation = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- assertCollectionAddin(add_comments = TRUE, insert = FALSE, indentation = 3)
  # Testing class
  expect_equal(
    class(output_16569),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16569,
    type = "character")
  # Testing values
  expect_equal(
    output_16569,
    c("# Check arguments ####", "assert_collection <- checkmate::makeAssertCollection()",
      "# checkmate::assert_ , add = assert_collection)", "checkmate::reportAssertions(assert_collection)",
      "# End of argument checks ####"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_16569),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16569),
    5L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_16569)),
    5L)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: indentation = -3
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = TRUE, insert = FALSE, indentation = -3)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'indentation': Element 1 ",
                         "is not >= 0.")),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: indentation = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(assertCollectionAddin(add_comments = TRUE, insert = FALSE, indentation = NA)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'indentation': Contains m",
                         "issing values (element 1).")),
    fixed = TRUE)

  # Testing assertCollectionAddin(add_comments = TRUE, i...
  # Changed from baseline: indentation = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- assertCollectionAddin(add_comments = TRUE, insert = FALSE, indentation = NULL)
  # Testing class
  expect_equal(
    class(output_17191),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17191,
    type = "character")
  # Testing values
  expect_equal(
    output_17191,
    c("# Check arguments ####", "assert_collection <- checkmate::makeAssertCollection()",
      "# checkmate::assert_ , add = assert_collection)", "checkmate::reportAssertions(assert_collection)",
      "# End of argument checks ####"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_17191),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17191),
    5L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17191)),
    5L)

  ## Finished testing 'assertCollectionAddin'                                 ####
  #

})
