% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_of_content_markdown.R
\name{render_toc}
\alias{render_toc}
\title{Render Table of Contents}
\usage{
render_toc(
  filename,
  toc_header_name = "Table of Contents",
  base_level = NULL,
  toc_depth = 3
)
}
\arguments{
\item{filename}{Name of RMarkdown or Markdown document}

\item{toc_header_name}{The table of contents header name. If specified, any
header with this format will not be included in the TOC. Set to \code{NULL} to
include the TOC itself in the TOC (but why?).}

\item{base_level}{Starting level of the lowest header level. Any headers
prior to the first header at the base_level are dropped silently.}

\item{toc_depth}{Maximum depth for TOC, relative to base_level. Default is
\code{toc_depth = 3}, which results in a TOC of at most 3 levels.}
}
\description{
From: https://gist.github.com/gadenbuie/c83e078bf8c81b035e32c3fc0cf04ee8
}
\details{
A simple function to extract headers from an RMarkdown or Markdown document
and build a table of contents. Returns a markdown list with links to the
headers using pandoc header identifiers.

WARNING: This function only works with hash-tag headers.

Because this function returns only the markdown list, the header for the
Table of Contents itself must be manually included in the text. Use
\code{toc_header_name} to exclude the table of contents header from the TOC, or
set to \code{NULL} for it to be included.
}
\section{Usage}{

Just drop in a chunk where you want the toc to appear (set \code{echo=FALSE}):\preformatted{# Table of Contents

```\{r echo=FALSE\}
render_toc("/path/to/the/file.Rmd")
```
}
}

\keyword{internal}
