## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.path = "man/figures/vignette_intro-",
  dpi = 92,
  fig.retina = 2
)

## ----eval=FALSE---------------------------------------------------------------
#  install.packages("xpectr")

## ----eval=FALSE---------------------------------------------------------------
#  # install.packages("devtools")
#  devtools::install_github("ludvigolsen/xpectr")

## ----warning=FALSE, message=FALSE---------------------------------------------
library(xpectr)
library(testthat)
library(dplyr)

# Set a seed
# When R > 3.6.0, it sets sampling.kind to "Rounding" to make
# tests compatible with previous versions of R
set_test_seed(42)

## -----------------------------------------------------------------------------
# Some data
num_vec <- 1:10
long_vec <- c(LETTERS, letters)
a_factor <- factor(c("a","b","c"))

df <- data.frame(
  'a' = c(1, 2, 3),
  'b' = c('t', 'y', 'u'),
  "c" = a_factor,
  stringsAsFactors = FALSE
) %>% 
  dplyr::group_by(a)

# A function with side effects
fn <- function(raise = FALSE){
  message("Hi! I'm Kevin, your favorite message!")
  warning("G'Day Mam! I'm a warning to the world!")
  message("Kevin is ma name! Yesss!")
  warning("Hopefully the whole world will see me :o")
  if (isTRUE(raise)){
    stop("Lord Evil Error has arrived! Yeehaaa")
  }
  "the output"
}

## -----------------------------------------------------------------------------
# Inspect num_vec
num_vec

## ----eval=FALSE---------------------------------------------------------------
#  # Generate expectations
#  gxs_selection("num_vec")
#  
#  # Inserts the following tests:
#  
#  ## Testing 'num_vec'                                                        ####
#  ## Initially generated by xpectr
#  xpectr::set_test_seed(42)
#  # Testing class
#  expect_equal(
#    class(num_vec),
#    "integer",
#    fixed = TRUE)
#  # Testing type
#  expect_type(
#    num_vec,
#    type = "integer")
#  # Testing values
#  expect_equal(
#    num_vec,
#    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
#    tolerance = 1e-4)
#  # Testing names
#  expect_equal(
#    names(num_vec),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(num_vec),
#    10L)
#  # Testing sum of element lengths
#  expect_equal(
#    sum(xpectr::element_lengths(num_vec)),
#    10L)
#  ## Finished testing 'num_vec'                                               ####
#  

## -----------------------------------------------------------------------------
# Inspect a_factor
a_factor

## ----eval=FALSE---------------------------------------------------------------
#  # Generate expectations
#  gxs_selection("a_factor")
#  
#  # Inserts the following tests:
#  
#  ## Testing 'a_factor'                                                       ####
#  ## Initially generated by xpectr
#  xpectr::set_test_seed(42)
#  # Testing is factor
#  expect_true(
#    is.factor(a_factor))
#  # Testing values
#  expect_equal(
#    as.character(a_factor),
#    c("a", "b", "c"),
#    fixed = TRUE)
#  # Testing names
#  expect_equal(
#    names(a_factor),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(a_factor),
#    3L)
#  # Testing number of levels
#  expect_equal(
#    nlevels(a_factor),
#    3L)
#  # Testing levels
#  expect_equal(
#    levels(a_factor),
#    c("a", "b", "c"),
#    fixed = TRUE)
#  ## Finished testing 'a_factor'                                              ####
#  

## -----------------------------------------------------------------------------
# Inspect long_vec
long_vec

## ----eval=FALSE---------------------------------------------------------------
#  # Generate expectations
#  gxs_selection("long_vec")
#  
#  # Inserts the following tests:
#  
#  ## Testing 'long_vec'                                                       ####
#  ## Initially generated by xpectr
#  xpectr::set_test_seed(42)
#  # Testing class
#  expect_equal(
#    class(long_vec),
#    "character",
#    fixed = TRUE)
#  # Testing type
#  expect_type(
#    long_vec,
#    type = "character")
#  # Testing values
#  expect_equal(
#    xpectr::smpl(long_vec, n = 30),
#    c("C", "E", "G", "J", "K", "N", "O", "Q", "R", "S", "T", "W", "Y",
#      "Z", "b", "c", "d", "e", "h", "i", "j", "k", "l", "o", "p",
#      "r", "v", "w", "y", "z"),
#    fixed = TRUE)
#  # Testing names
#  expect_equal(
#    names(xpectr::smpl(long_vec, n = 30)),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(long_vec),
#    52L)
#  # Testing sum of element lengths
#  expect_equal(
#    sum(xpectr::element_lengths(long_vec)),
#    52L)
#  ## Finished testing 'long_vec'                                              ####
#  

## -----------------------------------------------------------------------------
# Inspect df
df

## ----eval=FALSE---------------------------------------------------------------
#  # Generate expectations
#  gxs_selection("df")
#  
#  # Inserts the following tests:
#  
#  ## Testing 'df'                                                             ####
#  ## Initially generated by xpectr
#  xpectr::set_test_seed(42)
#  # Testing class
#  expect_equal(
#    class(df),
#    c("grouped_df", "tbl_df", "tbl", "data.frame"),
#    fixed = TRUE)
#  # Testing column values
#  expect_equal(
#    df[["a"]],
#    c(1, 2, 3),
#    tolerance = 1e-4)
#  expect_equal(
#    df[["b"]],
#    c("t", "y", "u"),
#    fixed = TRUE)
#  expect_equal(
#    df[["c"]],
#    structure(1:3, .Label = c("a", "b", "c"), class = "factor"))
#  # Testing column names
#  expect_equal(
#    names(df),
#    c("a", "b", "c"),
#    fixed = TRUE)
#  # Testing column classes
#  expect_equal(
#    xpectr::element_classes(df),
#    c("numeric", "character", "factor"),
#    fixed = TRUE)
#  # Testing column types
#  expect_equal(
#    xpectr::element_types(df),
#    c("double", "character", "integer"),
#    fixed = TRUE)
#  # Testing dimensions
#  expect_equal(
#    dim(df),
#    c(3L, 3L))
#  # Testing group keys
#  expect_equal(
#    colnames(dplyr::group_keys(df)),
#    "a",
#    fixed = TRUE)
#  ## Finished testing 'df'                                                    ####
#  

## -----------------------------------------------------------------------------
# Inspect fn
fn

## ----eval=FALSE---------------------------------------------------------------
#  # Generate expectations
#  gxs_selection("fn()")
#  
#  # Inserts the following tests:
#  
#  ## Testing 'fn()'                                                           ####
#  ## Initially generated by xpectr
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  # Assigning side effects
#  side_effects_19148 <- xpectr::capture_side_effects(fn(), reset_seed = TRUE)
#  expect_equal(
#    xpectr::strip(side_effects_19148[['warnings']]),
#    xpectr::strip(c("G'Day Mam! I'm a warning to the world!", "Hopefully the whole world will see me :o")),
#    fixed = TRUE)
#  expect_equal(
#    xpectr::strip(side_effects_19148[['messages']]),
#    xpectr::strip(c("Hi! I'm Kevin, your favorite message!\n", "Kevin is ma name! Yesss!\n")),
#    fixed = TRUE)
#  # Assigning output
#  output_19148 <- xpectr::suppress_mw(fn())
#  # Testing class
#  expect_equal(
#    class(output_19148),
#    "character",
#    fixed = TRUE)
#  # Testing type
#  expect_type(
#    output_19148,
#    type = "character")
#  # Testing values
#  expect_equal(
#    output_19148,
#    "the output",
#    fixed = TRUE)
#  # Testing names
#  expect_equal(
#    names(output_19148),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(output_19148),
#    1L)
#  # Testing sum of element lengths
#  expect_equal(
#    sum(xpectr::element_lengths(output_19148)),
#    1L)
#  ## Finished testing 'fn()'                                                  ####
#  
#  # In case of errors, the warnings and messages aren't tested
#  
#  gxs_selection("fn(raise = TRUE)")
#  
#  # Inserts the following tests:
#  
#  ## Testing 'fn(raise = TRUE)'                                               ####
#  ## Initially generated by xpectr
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  expect_error(
#    xpectr::strip_msg(fn(raise = TRUE)),
#    xpectr::strip("Lord Evil Error has arrived! Yeehaaa"),
#    fixed = TRUE)
#  ## Finished testing 'fn(raise = TRUE)'                                      ####
#  

## ----eval=FALSE---------------------------------------------------------------
#  # Define a function with arguments
#  fn <- function(x, y, z = 10) {
#    if (x > 3) stop("'x' > 3")
#    if (y < 0) warning("'y'<0")
#    if (z == 10) message("'z' was 10!")
#    x + y + z
#  }
#  
#  # Create tests for the function
#  # Note: We currently need to specify the list of arguments
#  # in the function call
#  gxs_function(fn = fn,
#               args_values = list(
#                 "x" = list(2, 4, NA),
#                 "y" = list(0,-1),
#                 "z" = list(5, 10)
#               ))
#  
#  # Inserts the following tests:
#  
#  ## Testing 'fn'                                                             ####
#  ## Initially generated by xpectr
#  # Testing different combinations of argument values
#  
#  # Testing fn(x = 2, y = 0, z = 5)
#  xpectr::set_test_seed(42)
#  # Assigning output
#  output_19148 <- fn(x = 2, y = 0, z = 5)
#  # Testing class
#  expect_equal(
#    class(output_19148),
#    "numeric",
#    fixed = TRUE)
#  # Testing type
#  expect_type(
#    output_19148,
#    type = "double")
#  # Testing values
#  expect_equal(
#    output_19148,
#    7,
#    tolerance = 1e-4)
#  # Testing names
#  expect_equal(
#    names(output_19148),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(output_19148),
#    1L)
#  # Testing sum of element lengths
#  expect_equal(
#    sum(xpectr::element_lengths(output_19148)),
#    1L)
#  
#  # Testing fn(x = 4, y = 0, z = 5)
#  # Changed from baseline: x = 4
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  expect_error(
#    xpectr::strip_msg(fn(x = 4, y = 0, z = 5)),
#    xpectr::strip("'x' > 3"),
#    fixed = TRUE)
#  
#  # Testing fn(x = NA, y = 0, z = 5)
#  # Changed from baseline: x = NA
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  expect_error(
#    xpectr::strip_msg(fn(x = NA, y = 0, z = 5)),
#    xpectr::strip("missing value where TRUE/FALSE needed"),
#    fixed = TRUE)
#  
#  # Testing fn(x = NULL, y = 0, z = 5)
#  # Changed from baseline: x = NULL
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  expect_error(
#    xpectr::strip_msg(fn(x = NULL, y = 0, z = 5)),
#    xpectr::strip("argument is of length zero"),
#    fixed = TRUE)
#  
#  # Testing fn(x = 2, y = -1, z = 5)
#  # Changed from baseline: y = -1
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  # Assigning side effects
#  side_effects_16417 <- xpectr::capture_side_effects(fn(x = 2, y = -1, z = 5), reset_seed = TRUE)
#  expect_equal(
#    xpectr::strip(side_effects_16417[['warnings']]),
#    xpectr::strip("'y'<0"),
#    fixed = TRUE)
#  expect_equal(
#    xpectr::strip(side_effects_16417[['messages']]),
#    xpectr::strip(character(0)),
#    fixed = TRUE)
#  # Assigning output
#  output_16417 <- xpectr::suppress_mw(fn(x = 2, y = -1, z = 5))
#  # Testing class
#  expect_equal(
#    class(output_16417),
#    "numeric",
#    fixed = TRUE)
#  # Testing type
#  expect_type(
#    output_16417,
#    type = "double")
#  # Testing values
#  expect_equal(
#    output_16417,
#    6,
#    tolerance = 1e-4)
#  # Testing names
#  expect_equal(
#    names(output_16417),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(output_16417),
#    1L)
#  # Testing sum of element lengths
#  expect_equal(
#    sum(xpectr::element_lengths(output_16417)),
#    1L)
#  
#  # Testing fn(x = 2, y = NULL, z = 5)
#  # Changed from baseline: y = NULL
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  expect_error(
#    xpectr::strip_msg(fn(x = 2, y = NULL, z = 5)),
#    xpectr::strip("argument is of length zero"),
#    fixed = TRUE)
#  
#  # Testing fn(x = 2, y = 0, z = 10)
#  # Changed from baseline: z = 10
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  # Assigning side effects
#  side_effects_17365 <- xpectr::capture_side_effects(fn(x = 2, y = 0, z = 10), reset_seed = TRUE)
#  expect_equal(
#    xpectr::strip(side_effects_17365[['warnings']]),
#    xpectr::strip(character(0)),
#    fixed = TRUE)
#  expect_equal(
#    xpectr::strip(side_effects_17365[['messages']]),
#    xpectr::strip("'z' was 10!\n"),
#    fixed = TRUE)
#  # Assigning output
#  output_17365 <- xpectr::suppress_mw(fn(x = 2, y = 0, z = 10))
#  # Testing class
#  expect_equal(
#    class(output_17365),
#    "numeric",
#    fixed = TRUE)
#  # Testing type
#  expect_type(
#    output_17365,
#    type = "double")
#  # Testing values
#  expect_equal(
#    output_17365,
#    12,
#    tolerance = 1e-4)
#  # Testing names
#  expect_equal(
#    names(output_17365),
#    NULL,
#    fixed = TRUE)
#  # Testing length
#  expect_equal(
#    length(output_17365),
#    1L)
#  # Testing sum of element lengths
#  expect_equal(
#    sum(xpectr::element_lengths(output_17365)),
#    1L)
#  
#  # Testing fn(x = 2, y = 0, z = NULL)
#  # Changed from baseline: z = NULL
#  xpectr::set_test_seed(42)
#  # Testing side effects
#  expect_error(
#    xpectr::strip_msg(fn(x = 2, y = 0, z = NULL)),
#    xpectr::strip("argument is of length zero"),
#    fixed = TRUE)
#  
#  ## Finished testing 'fn'                                                    ####
#  

## ----eval=FALSE---------------------------------------------------------------
#  initializeGXSFunctionAddin("fn")
#  
#  # Inserts the following:
#  
#  # Generate expectations for 'fn'
#  # Tip: comment out the gxs_function() call
#  # so it is easy to regenerate the tests
#  xpectr::set_test_seed(42)
#  xpectr::gxs_function(
#    fn = fn,
#    args_values = list(
#      "x" = list(),
#      "y" = list(),
#      "z" = list(10)
#    )
#  )
#  
#  #
#  

## ----eval=FALSE---------------------------------------------------------------
#  wrapStringAddin("This is a fairly long sentence that we would very very much like to make shorter in our test file!")
#  
#  # Inserts the following:
#  
#  paste0("This is a fairly long sentence that we would very very much ",
#         "like to make shorter in our test file!")
#  

## ----eval=FALSE---------------------------------------------------------------
#  initializeTestthatAddin()
#  
#  # Inserts the following:
#  
#  test_that("testing ...()", {
#    xpectr::set_test_seed(42)
#  
#    # ...
#  
#  })
#  

## ----eval=FALSE---------------------------------------------------------------
#  assertCollectionAddin()
#  
#  # Inserts the following:
#  
#  # Check arguments ####
#  assert_collection <- checkmate::makeAssertCollection()
#  # checkmate::assert_ , add = assert_collection)
#  checkmate::reportAssertions(assert_collection)
#  # End of argument checks ####
#  

## ----eval=FALSE---------------------------------------------------------------
#  v <- c(1, 2, 3)
#  
#  dputSelectedAddin("v")  # "v" is the selected code
#  
#  # Inserts the following:
#  
#  c(1, 2, 3)
#  

