% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_style.R
\name{auto_detect_left_headers}
\alias{auto_detect_left_headers}
\title{Uses the presence of '(all)' in the leftmost columns of data to detect that these
columns are really left headers rather than body columns}
\usage{
auto_detect_left_headers(tab, keyword = "(all)")
}
\arguments{
\item{tab}{a tab object}

\item{keyword}{The keyword to use to detect summarisation.  Uses '(all)' by default because this is what reshape2::dcast uses}
}
\description{
Populates tab$body$left_header_colnames automatically
}
\examples{
crosstab <- read.csv(system.file("extdata", "example_crosstab.csv", package="xltabr"))
tab <- initialise()
tab <- add_body(tab, crosstab)
tab <- auto_detect_left_headers(tab)
}
