/*
 * Decompiled with CFR 0.152.
 */
package org.cran.rexcel;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class RInterface {
    public int NCOLS = 0;
    public int NROWS = 0;
    public static final double NA_DOUBLE = Double.NaN;
    public static final int NA_INT = Integer.MIN_VALUE;
    public static final String NA_STRING = "NA";
    public static final int NA_BOOL = -128;

    public static boolean isNA(double x) {
        return Double.isNaN(x);
    }

    public static boolean isNA(int x) {
        return x == Integer.MIN_VALUE;
    }

    public static boolean isNA(String x) {
        return x == null;
    }

    public double[] readColDoubles(Sheet sheet, int startRowIndex, int endRowIndex, int colIndex) {
        int N = endRowIndex - startRowIndex + 1;
        double[] res = new double[N];
        int i = 0;
        while (i < N) {
            Row row = sheet.getRow(startRowIndex + i);
            if (row == null) {
                res[i] = Double.NaN;
            } else {
                Cell cell = row.getCell(colIndex, Row.CREATE_NULL_AS_BLANK);
                switch (cell.getCellType()) {
                    case 1: {
                        try {
                            res[i] = Double.valueOf(cell.getStringCellValue());
                        }
                        catch (NumberFormatException nfe) {
                            res[i] = Double.NaN;
                        }
                        break;
                    }
                    case 0: {
                        res[i] = cell.getNumericCellValue();
                        break;
                    }
                    case 2: {
                        try {
                            res[i] = cell.getNumericCellValue();
                        }
                        catch (IllegalStateException e) {
                            res[i] = Double.NaN;
                        }
                        break;
                    }
                    case 4: {
                        res[i] = cell.getBooleanCellValue() ? 1 : 0;
                        break;
                    }
                    case 5: {
                        res[i] = Double.NaN;
                        break;
                    }
                    default: {
                        res[i] = Double.NaN;
                    }
                }
            }
            ++i;
        }
        return res;
    }

    public String[] readColStrings(Sheet sheet, int startRowIndex, int endRowIndex, int colIndex) {
        int N = endRowIndex - startRowIndex + 1;
        String[] res = new String[N];
        int i = 0;
        while (i < N) {
            Row row = sheet.getRow(startRowIndex + i);
            if (row == null) {
                res[i] = "";
            } else {
                Cell cell = row.getCell(colIndex, Row.CREATE_NULL_AS_BLANK);
                switch (cell.getCellType()) {
                    case 1: {
                        res[i] = cell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        res[i] = Double.toString(cell.getNumericCellValue());
                        break;
                    }
                    case 2: {
                        try {
                            res[i] = cell.getStringCellValue();
                        }
                        catch (IllegalStateException e) {
                            res[i] = NA_STRING;
                        }
                        break;
                    }
                    case 4: {
                        res[i] = new Boolean(cell.getBooleanCellValue()).toString();
                        break;
                    }
                    case 3: {
                        res[i] = "";
                        break;
                    }
                    case 5: {
                        res[i] = "ERROR";
                        break;
                    }
                    default: {
                        res[i] = "";
                    }
                }
            }
            ++i;
        }
        return res;
    }

    public String[] readRowStrings(Sheet sheet, int startColIndex, int endColIndex, int rowIndex) {
        int N = endColIndex - startColIndex + 1;
        String[] res = new String[N];
        Row row = sheet.getRow(rowIndex);
        int i = 0;
        while (i < N) {
            Cell cell = row.getCell(startColIndex + i, Row.CREATE_NULL_AS_BLANK);
            switch (cell.getCellType()) {
                case 1: {
                    res[i] = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    res[i] = Double.toString(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    res[i] = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    res[i] = new Boolean(cell.getBooleanCellValue()).toString();
                    break;
                }
                default: {
                    res[i] = "";
                }
            }
            ++i;
        }
        return res;
    }
}

