% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPayments.R
\name{getPayments}
\alias{getPayments}
\title{Returns all payments.}
\usage{
getPayments(limit, cursor = NULL, order = "asc", data.table = TRUE,
  domain = "public")
}
\arguments{
\item{limit}{numeric - the number of records to return. Default is 10.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{domain}{character - signalling to query the testnet or public network. Can be either "testnet" or "public". boolean - if TRUE, a data.table is overwritten and the server-side streaming capability is utilised. A list will be returned.}
}
\value{
data.table or list
}
\description{
Return all payments operations that are a part of a valid transaction.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/payments-all.html
}
\examples{
getPayments(20, domain = "testnet")
}
