% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfScaleFactor.R
\name{RandomGaussianSF}
\alias{RandomGaussianSF}
\title{Random Gaussian scale factor (RGSF).}
\usage{
RandomGaussianSF(lF)
}
\arguments{
\item{lF}{Local configuration.}
}
\value{
A scale factor.
}
\description{
The scale factor is drawn randomly from 
             one of the two Gaussian distributions 
             \code{abs(rnorm(1, 0.3, 0.3))} or 
             \code{abs(rnorm(1, 0.7, 0.3))}.
}
\details{
For details, see section 5 of Sharma et al. (2019), 
         p. 932 or Li and Yin (2016), p. 555. 
         Note that the range given in both papers is false.
}
\examples{
RandomGaussianSF(lFxegaDfGene) 
RandomGaussianSF(lFxegaDfGene) 
RandomGaussianSF(lFxegaDfGene) 
}
\references{
Li, Xiangtao AND Yin, Minghao (2016)
Modified differential evolution with self-adaptive parameters method.
Journal of Combinatorial Optimization 31(2), 546-576. 
(doi:10.1007/s10878-014-9773-6)
}
\seealso{
Other Scale Factor: 
\code{\link{CauchySF}()},
\code{\link{ConstScaleFactor}()},
\code{\link{DETVSF}()},
\code{\link{FitnessBasedSelfAdaptiveSF}()},
\code{\link{UniformRandomScaleFactor}()},
\code{\link{UniformRandomScaleFactorDERSF}()}
}
\concept{Scale Factor}
