% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_x3p.R
\name{rotate_x3p}
\alias{rotate_x3p}
\title{Rotate an x3p object}
\usage{
rotate_x3p(x3p, angle = 90)
}
\arguments{
\item{x3p}{x3p object}

\item{angle}{rotate counter-clockwise by angle degrees given as 90, 180, 270 degree (or -90, -180, -270).}
}
\description{
Rotate the surface matrix of an x3p object. Also adjust meta information.
}
\examples{
logo <- read_x3p(system.file("csafe-logo.x3p", package="x3ptools"))
dim(logo$surface.matrix)
\dontrun{
image_x3p(logo)
}
# rotate the image by 90 degrees clock-wise:
logo90 <- rotate_x3p(logo, 90)
dim(logo90$surface.matrix)
\dontrun{
image_x3p(logo90)
}
}
