% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvar.R
\name{wvar}
\alias{wvar}
\alias{wvar.lts}
\alias{wvar.gts}
\alias{wvar.ts}
\alias{wvar.imu}
\alias{wvar.default}
\title{Wavelet Variance}
\usage{
wvar(x, ...)

\method{wvar}{lts}(
  x,
  decomp = "modwt",
  filter = "haar",
  nlevels = NULL,
  alpha = 0.05,
  robust = FALSE,
  eff = 0.6,
  to.unit = NULL,
  ...
)

\method{wvar}{gts}(
  x,
  decomp = "modwt",
  filter = "haar",
  nlevels = NULL,
  alpha = 0.05,
  robust = FALSE,
  eff = 0.6,
  to.unit = NULL,
  ...
)

\method{wvar}{ts}(
  x,
  decomp = "modwt",
  filter = "haar",
  nlevels = NULL,
  alpha = 0.05,
  robust = FALSE,
  eff = 0.6,
  to.unit = NULL,
  ...
)

\method{wvar}{imu}(
  x,
  decomp = "modwt",
  filter = "haar",
  nlevels = NULL,
  alpha = 0.05,
  robust = FALSE,
  eff = 0.6,
  to.unit = NULL,
  ...
)

\method{wvar}{default}(
  x,
  decomp = "modwt",
  filter = "haar",
  nlevels = NULL,
  alpha = 0.05,
  robust = FALSE,
  eff = 0.6,
  freq = 1,
  from.unit = NULL,
  to.unit = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1.}

\item{...}{Further arguments passed to or from other methods.}

\item{decomp}{A \code{string} that indicates whether to use a "dwt" or "modwt" decomposition.}

\item{filter}{A \code{string} that specifies which wavelet filter to use.}

\item{nlevels}{An \code{integer} that indicates the level of decomposition. It must be less than or equal to floor(log2(length(x))).}

\item{alpha}{A \code{double} that specifies the significance level which in turn specifies the \eqn{1-\alpha} confidence level.}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{to.unit}{A \code{string} indicating the unit to which the data is converted.}

\item{freq}{A \code{numeric} that provides the rate of samples.}

\item{from.unit}{A \code{string} indicating the unit from which the data is converted.}
}
\value{
A \code{list} with the structure:
\itemize{
  \item "variance": Wavelet Variance
  \item "ci_low": Lower CI
  \item "ci_high": Upper CI
  \item "robust": Robust active 
  \item "eff": Efficiency level for Robust calculation
  \item "alpha": p value used for CI
  \item "unit": String representation of the unit
}
}
\description{
Calculates the (MO)DWT wavelet variance
}
\details{
The default value of \code{nlevels} will be set to \eqn{\left\lfloor {{{\log }_2}\left( {length\left( x \right)} \right)} \right\rfloor}{floor(log2(length(x)))}, unless otherwise specified.
}
\examples{
set.seed(999)
x = rnorm(100)

# Default
wvar(x)

# Robust
wvar(x, robust = TRUE, eff=0.3)

# Classical
wvar(x, robust = FALSE, eff=0.3)

# 90\% Confidence Interval 
wvar(x, alpha = 0.10)
}
\author{
James Balamuta, Justin Lee and Stephane Guerrier
}
