% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlm_methods.R
\name{wlm_methods}
\alias{wlm_methods}
\alias{summary.wlm}
\alias{print.wlm}
\alias{set_times.wlm}
\alias{set_timescales.wlm}
\alias{set_coefs.wlm}
\alias{set_modval.wlm}
\alias{set_coher.wlm}
\alias{set_dat.wlm}
\alias{set_wtopt.wlm}
\alias{set_norm.wlm}
\alias{set_wts.wlm}
\alias{get_times.wlm}
\alias{get_timescales.wlm}
\alias{get_coefs.wlm}
\alias{get_modval.wlm}
\alias{get_coher.wlm}
\alias{get_dat.wlm}
\alias{get_wtopt.wlm}
\alias{get_norm.wlm}
\alias{get_wts.wlm}
\title{Basic methods for the \code{wlm} class}
\usage{
\method{summary}{wlm}(object, ...)

\method{print}{wlm}(x, ...)

\method{set_times}{wlm}(obj, newval)

\method{set_timescales}{wlm}(obj, newval)

\method{set_coefs}{wlm}(obj, newval)

\method{set_modval}{wlm}(obj, newval)

\method{set_coher}{wlm}(obj, newval)

\method{set_dat}{wlm}(obj, newval)

\method{set_wtopt}{wlm}(obj, newval)

\method{set_norm}{wlm}(obj, newval)

\method{set_wts}{wlm}(obj, newval)

\method{get_times}{wlm}(obj)

\method{get_timescales}{wlm}(obj)

\method{get_coefs}{wlm}(obj)

\method{get_modval}{wlm}(obj)

\method{get_coher}{wlm}(obj)

\method{get_dat}{wlm}(obj)

\method{get_wtopt}{wlm}(obj)

\method{get_norm}{wlm}(obj)

\method{get_wts}{wlm}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{wlm}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.wlm} produces a summary of a \code{wlm} object.
A \code{print.wlm} method is also available. For \code{wlm} objects, 
\code{set_*} and \code{get_*} methods are available for all slots (see
the documentation for \code{wlm} for a list). The \code{set_*} methods 
just throw an error, to prevent breaking the consistency between the 
slots of a \code{wlm} object.
}
\description{
Set, get, summary, and print methods for the \code{wlm} class.
}
\examples{
times<-1:30
dat<-list(v1=matrix(rnorm(300),10,30),v2=matrix(rnorm(300),10,30),v3=matrix(rnorm(300),10,30),
          v4=matrix(rnorm(300),10,30),v5=matrix(rnorm(300),10,30))
dat<-lapply(FUN=function(x){cleandat(x,times,1)$cdat},X=dat)
resp<-2
pred<-c(1,3,4)
norm<-"powall"
h<-wlm(dat,times,resp,pred,norm)
get_times(h)
summary(h)
print(h)

}
\seealso{
\code{\link{wlm}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
