% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt.R
\name{wt}
\alias{wt}
\title{Computes the wavelet transform of a timeseries. Also the creator function for the
\code{wt} class.}
\usage{
wt(t.series, times, scale.min = 2, scale.max.input = NULL, sigma = 1.05,
  f0 = 1)
}
\arguments{
\item{t.series}{A timeseries of real values}

\item{times}{A vector of time step values (e.g., years), spacing 1}

\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation that is guaranteed to be examined}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Should be greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelope. Defaults to 1.}
}
\value{
\code{wt} returns an object of class \code{wt}.  Slots are: 
\item{values}{A matrix of complex numbers, of dimensions \code{length(t.series)} by the number of timescales. Entries not considered reliable (longer timescales, near the edges of the time span) are set to NA.}
\item{times}{The time steps specified (e.g. years)}
\item{wtopt}{The inputted wavelet transform options scale.min, scale.max.input, sigma, f0 in a list}
\item{timescales}{The timescales (1/frequency) computed for the wavelet transform}
\item{dat}{The data vector from which the transform was computed}
}
\description{
Computes the wavelet transform of a timeseries. Also the creator function for the
\code{wt} class. The \code{wt} class inherits from the \code{tts} class, which
inherits from the \code{list} class.
}
\note{
Important for interpreting the phase: the phases grow through time, i.e., they turn anti-clockwise.
}
\examples{
time1<-1:100
time2<-101:200
ts1p1<-sin(2*pi*time1/15)
ts1p2<-0*time1
ts2p1<-0*time2
ts2p2<-sin(2*pi*time2/8)
ts1<-ts1p1+ts1p2
ts2<-ts2p1+ts2p2
ts<-c(ts1,ts2)
ra<-rnorm(200,mean=0,sd=0.5)
t.series<-ts+ra
t.series<-t.series-mean(t.series)
times<-c(time1,time2)
res<-wt(t.series, times)

}
\seealso{
\code{\link{wt_methods}}, \code{\link{tts}}, \code{\link{plotmag}}, \code{\link{plotphase}},
\code{browseVignettes("wsyn")}
}
\author{
Lawrence Sheppard \email{lwsheppard@ku.edu}, Jonathan Walter 
\email{jaw3es@virginia.edu}, Daniel Reuman \email{reuman@ku.edu}
}
