% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_census_data.R
\name{get_census_data}
\alias{get_census_data}
\title{Multilevel Census data download function.}
\usage{
get_census_data(
  key = Sys.getenv("CENSUS_API_KEY"),
  states,
  age = FALSE,
  sex = FALSE,
  year = "2020",
  census.geo = c("tract", "block", "block_group", "county", "place", "zcta"),
  retry = 3,
  county.list = NULL
)
}
\arguments{
\item{key}{A character string containing a valid Census API key,
which can be requested from the
\href{https://api.census.gov/data/key_signup.html}{U.S. Census API key signup page}.

By default, attempts to find a census key stored in an
\link[=Sys.getenv]{environment variable} named \code{CENSUS_API_KEY}.}

\item{states}{which states to extract Census data for, e.g., \code{c("NJ", "NY")}.}

\item{age}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on
age or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Age | Race).
If \code{\var{sex}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{sex}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on
sex or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Sex | Race).
If \code{\var{age}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{year}{A character object specifying the year of U.S. Census data to be downloaded.
Use \code{"2010"}, or \code{"2020"}. Default is \code{"2020"}.
Warning: 2020 U.S. Census data is downloaded only when \code{\var{age}} and
\code{\var{sex}} are both \code{FALSE}.}

\item{census.geo}{An optional character vector specifying what level of
geography to use to merge in U.S. Census 2010 geographic data. Currently
\code{"county"}, \code{"tract"}, \code{"block"}, and \code{"place"} are supported.}

\item{retry}{The number of retries at the census website if network interruption occurs.}

\item{county.list}{A named list of character vectors of counties present in your \var{voter.file}, per state.}
}
\value{
Output will be an object of class \code{list} indexed by state.
Output will contain a subset of the following elements:
\code{state}, \code{age}, \code{sex},
\code{county}, \code{tract}, \code{block_group}, \code{block}, and \code{place}.
}
\description{
\code{get_census_data} returns county-, tract-, and block-level Census data
for specified state(s). Using this function to download Census data in advance
can save considerable time when running \code{predict_race} and \code{census_helper}.
}
\examples{
\dontrun{get_census_data(states = c("NJ", "NY"), age = TRUE, sex = FALSE)}
\dontrun{get_census_data(states = "MN", age = FALSE, sex = FALSE, year = "2020")}
}
