% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpipe.R
\name{apply_right}
\alias{apply_right}
\title{S3 dispatch on class of pipe_right_argument.}
\usage{
apply_right(pipe_left_arg, pipe_right_arg, pipe_environment, left_arg_name,
  pipe_string, right_arg_name)
}
\arguments{
\item{pipe_left_arg}{left argument}

\item{pipe_right_arg}{right argument}

\item{pipe_environment}{environment to evaluate in}

\item{left_arg_name}{name, if not NULL name of left argument.}

\item{pipe_string}{character, name of pipe operator.}

\item{right_arg_name}{name, if not NULL name of right argument.}
}
\value{
result
}
\description{
Triggered if right hand side of pipe stage was a name that does not resolve to a function.
For formal documentation please see \url{https://github.com/WinVector/wrapr/blob/master/extras/wrapr_pipe.pdf}.
}
\examples{

# simulate a function pointer
apply_right.list <- function(pipe_left_arg,
                             pipe_right_arg,
                             pipe_environment,
                             left_arg_name,
                             pipe_string,
                             right_arg_name) {
  pipe_right_arg$f(pipe_left_arg)
}

f <- list(f=sin)
2 \%.>\% f
f$f <- cos
2 \%.>\% f

}
\seealso{
\code{\link{apply_left}}, \code{\link{apply_right_S4}}
}
