% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSdrf.R
\name{readSdrf}
\alias{readSdrf}
\title{Read proteomics meta-data as sdrf file 
 
This function allows reading proteomics meta-data from sdrf file, as they are provided on https://github.com/bigbio/proteomics-metadata-standard. 
Then, a data.frame with all annotation data will be returned. To stay conform with the (non-obligatory) recommendations, column-names will be shown as lower caps.  
The package utils must be installed.}
\usage{
readSdrf(
  fi,
  chCol = "auto",
  urlPrefix = "github",
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{fi}{(character) main input; may be full path or url to the file with meta-annotation. If a short project-name is given, 
it will be searched based at the location of \code{urlPrefix}}

\item{chCol}{(character, length=1) optional checking of column-names}

\item{urlPrefix}{(character, length=1) prefix to add to search when no complete path or url is given on \code{fi}, defaults to proteomics-metadata-standard on github}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns the content of Sdrf-file as data.frame
}
\description{
Read proteomics meta-data as sdrf file 
 
This function allows reading proteomics meta-data from sdrf file, as they are provided on https://github.com/bigbio/proteomics-metadata-standard. 
Then, a data.frame with all annotation data will be returned. To stay conform with the (non-obligatory) recommendations, column-names will be shown as lower caps.  
The package utils must be installed.
}
\examples{

pxd001819 <- readSdrf("PXD001819")
str(pxd001819)

 
}
\seealso{
in \code{\link[utils]{read.table}}
}
