% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchNamesWithReverseParts.R
\name{matchNamesWithReverseParts}
\alias{matchNamesWithReverseParts}
\title{Value Matching with optional reversing of sub-parts of non-matching elements}
\usage{
matchNamesWithReverseParts(
  x,
  y,
  sep = "-",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(character) first vector for match}

\item{y}{(character) second vector for match}

\item{sep}{(character) separator between elements}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
index for matching (integer) x to y
}
\description{
This function provides a variant to \code{\link[base]{match}}, where initially non-matching elements of \code{x}  
will be tested by decomposing non-matching elements, reversing the parts in front and after the separator \code{sep} and re-matching.
If separator \code{sep} does not occur, a warning will be issued, if it occurs more than once, 
the parts before and after the first separartor will be used and a warning issued.
}
\examples{
tx1 <- c("a-b","a-c","d-a","d-b","b-c","d-c")
tmp <- triCoord(4)
tx2 <- paste(letters[tmp[,1]],letters[tmp[,2]],sep="-")
## Some matches won't be found, since 'a-d' got reversed to 'd-a', etc... 
match(tx1,tx1)  
matchNamesWithReverseParts(tx1,tx2)
}
\seealso{
\code{\link[base]{match}}
}
