% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchLinesAtGivenSlope.R
\name{.predRes}
\alias{.predRes}
\title{Calculate residues of (2-dim) linear model 'lMod'-prediction of/for 'dat'}
\usage{
.predRes(dat, lMod, regTy = "lin", useCol = 1:2)
}
\arguments{
\item{dat}{matrix or data.frame, main input}

\item{lMod}{linear model, only used to extract coefficients offset & slope}

\item{regTy}{(character) type of regression model}

\item{useCol}{(integer) columns to use}
}
\value{
This function returns a numeric vector of residues (for each line of dat)
}
\description{
This function calculates residues of (2-dim) linear model 'lMod'-prediction of/for 'dat' (using 2nd col of 'useCol' )
 (indexing in 'dat', matrix or data.frame with min 2 cols), using 1st col of 'useCol' as 'x'.
It may be used for comparing/identifying data close to regression  (eg re-finding data on autoregression line in FT-ICR)
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
}
\seealso{
\code{\link{searchLinesAtGivenSlope}}
}
