% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wqspt_plot.R
\name{wqspt_plot}
\alias{wqspt_plot}
\title{Plotting method for wqspt object}
\usage{
wqspt_plot(
  wqsptresults,
  FixedPalette = FALSE,
  InclKey = FALSE,
  AltMixName = NULL,
  AltOutcomeName = NULL,
  ViridisPalette = "D",
  StripTextSize = 14,
  AxisTextSize.Y = 12,
  AxisTextSize.X = 12,
  LegendTextSize = 14,
  PvalLabelSize = 5,
  HeatMapTextSize = 5
)
}
\arguments{
\item{wqsptresults}{An object of class \code{wqs_pt}.}

\item{FixedPalette}{If TRUE, the heatmap color key for the mixture weights has
categorical cutoffs with the following categories: <0.1, 0.1 - <0.2, 0.2 - <0.3,
and >= 0.3. If false, the heatmap color key is continuous and dependent on the
weight values.}

\item{InclKey}{If TRUE, a horizontal heatmap legend is included at the bottom
of the full plot.}

\item{AltMixName}{Defaults to NULL. If not NULL, these are alternative names
for the mixture components to be displayed on the heatmap y axis.}

\item{AltOutcomeName}{Defaults to NULL. If not NULL, this is an alternative
name for the outcome to be displayed on the heatmap x axis.}

\item{ViridisPalette}{Color palette to be used for the viridisLite
package-based coloring of the heatmap, with possible values from 'A' to 'E'.
Defaults to 'D'.}

\item{StripTextSize}{Text size for the plot strip labels. Defaults to 14.}

\item{AxisTextSize.Y}{Text size for the y axis text. Defaults to 12.}

\item{AxisTextSize.X}{Text size for the x axis text. Defaults to 12.}

\item{LegendTextSize}{Text text size for the legend text. Defaults to 14.}

\item{PvalLabelSize}{The geom_text size for the permutation test p-value
label. Defaults to 5.}

\item{HeatMapTextSize}{The geom_text size for the mixture weight heatmap
labels. Defaults to 5.}
}
\value{
Returns a list with 4 objects.

\item{FullPlot}{Two plots stacked vertically: (1) Forest plot of the beta WQS
coefficient with the naive confidence intervals as well as the permutation
test p-value (2) A heatmap of the WQS weights for each mixture component.}
\item{CoefPlot}{Forest plot of the beta WQS
coefficient with the naive confidence intervals as well as the permutation
test p-value.}
\item{WtPlot}{A heatmap of the WQS weights for each mixture component.}
\item{WtLegend}{A legend for the weights in the WtPlot heatmap.}
}
\description{
Generates plots to help visualize and summarize WQS permutation test results.
}
