% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossling.R
\name{summarise_items}
\alias{summarise_items}
\title{Get item-by-age summary statistics}
\usage{
summarise_items(item_data, db_args = NULL)
}
\arguments{
\item{item_data}{A dataframe as returned by \code{get_item_data()}.}

\item{db_args}{List with arguments to connect to wordbank mysql database
(host, dbname, user, and password).}
}
\value{
A dataframe with a row for each combination of item and age, and
  columns for summary statistics for the group: number of children
  (\code{n_children}), means (\code{comprehension}, \code{production}),
  standard deviations (\code{comprehension_sd}, \code{production_sd}); also
  retains item-level variables from \code{lang_items} (\code{item_id},
  \code{item_definition}, \code{uni_lemma}, \code{lexical_category}).
}
\description{
Get item-by-age summary statistics
}
\examples{
\donttest{
italian_items <- get_item_data(language = "Italian", form = "WG")
if (!is.null(italian_items)) {
  italian_dog <- dplyr::filter(italian_items, uni_lemma == "dog")
  italian_dog_summary <- summarise_items(italian_dog)
}
}
}
