% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRED_predict.R
\name{predict.STBDwDM}
\alias{predict.STBDwDM}
\title{predict.STBDwDM}
\usage{
\method{predict}{STBDwDM}(object, NewTimes, ...)
}
\arguments{
\item{object}{a \code{\link{STBDwDM}} model object for which predictions
are desired from.}

\item{NewTimes}{a numeric vector including desired time(s) points for prediction.}

\item{...}{other arguments.}
}
\value{
\code{predict.STBDwDM} returns a list containing the following objects.

  \describe{

  \item{\code{MuTauAlpha}}{A \code{list} containing three matrices, \code{mu},
  \code{tau} and \code{alpha}. Each matrix is dimension \code{NKeep x s}, where
  \code{s} is the number of new time points. Each matrix contains posterior
  samples obtained by Bayesian krigging.}

  \item{\code{Y}}{A \code{list} containing \code{s} posterior predictive distribution
  matrices. Each matrix is dimension \code{NKeep x s}, where \code{s}
  is the number of new time points. Each matrix is obtained through Bayesian krigging.}

  }
}
\description{
Predicts future observations from the \code{\link{STBDwDM}} model.
}
\details{
\code{predict.STBDwDM} uses Bayesian krigging to predict vectors at future
 time points. The function returns the krigged observed outcomes along with the
 observational level parameters (\code{mu}, \code{tau}, and \code{alpha}).
}
\author{
Samuel I. Berchuck
}

