% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.patient.R
\docType{data}
\name{new.patient}
\alias{new.patient}
\title{Example dataset containing 2 visits of a hypothetical patient with amyotrophic lateral sclerosis (ALS).}
\format{A data frame with 2 rows and 25 variables:
\describe{
  \item{subID}{patient's ID}
  \item{sex}{patient's sex}
  \item{bmi_premorbid}{premorbid body mass index}
  \item{bmi_diagnosis}{body mass index at disease diagnosis}
  \item{fvc_diagnosis}{forced vital capacity at disease diagnosis (a measure of respiratory functionality)}
  \item{familiality}{familiality of ALS}
  \item{genetics}{the result of a genetic screening over the most common ALS-associated genes}
  \item{ftd}{presence of frontotemporal dementia}
  \item{onset_site}{site of disease onset (limb/bulbar)}
  \item{onset_age}{age at disease onset}
  \item{visit_time}{month in which the current visit took place; the months start from 0}
  \item{niv}{the presence/absence up to the current visit of non-invasive ventilation}
  \item{peg}{the presence/absence up to the current visit of percutaneous endoscopic gastrostomy}
  \item{alsfrs_1}{Item 1 (SPEECH) of the the revised ALS Functional Rating Scale (ALSFRS-R): a 12-item questionnaire rated on a 0–4 point scale evaluating the observable functional status and change for patients with ALS over time}
  \item{alsfrs_2}{Item 2 (SALIVATION) of the ALSFRS-R}
  \item{alsfrs_3}{Item 3 (SWALLOWING) of the ALSFRS-R}
  \item{alsfrs_4}{Item 4 (HANDWRITING) of the ALSFRS-R}
  \item{alsfrs_5}{Item 5 (CUTTING FOOD AND HANDLING UTENSILS) of the ALSFRS-R}
  \item{alsfrs_6}{Item 6 (DRESSING AND HYGIENE) of the ALSFRS-R}
  \item{alsfrs_7}{Item 7 (TURNING IN BED AND ADJUSTING BED CLOTHES) of the ALSFRS-R}
  \item{alsfrs_8}{Item 8 (WALKING) of the ALSFRS-R}
  \item{alsfrs_9}{Item 9 (CLIMBING STAIRS) of the ALSFRS-R}
  \item{alsfrs_10}{Item 10 (DYSPNEA) of the ALSFRS-R}
  \item{alsfrs_11}{Item 11 (ORTHOPNEA) of the ALSFRS-R}
  \item{alsfrs_12}{Item 12 (RESPIRATORY INSUFFICIENCY) of the ALSFRS-R}
}}
\usage{
data(new.patient)
}
\description{
Example dataset containing 2 visits of a hypothetical patient with amyotrophic lateral sclerosis (ALS).
}
\keyword{datasets}
