% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndaRequest.R
\name{nda}
\alias{nda}
\title{Generate validated NDA submission templates created in the ./nda directory}
\usage{
nda(
  ...,
  csv = FALSE,
  rdata = FALSE,
  spss = FALSE,
  limited_dataset = FALSE,
  skip_prompt = TRUE
)
}
\arguments{
\item{...}{Strings, specifying the measures to process, which can be a Mongo collection, REDCap instrument, or Qualtrics survey.}

\item{csv}{Optional; Boolean, if TRUE creates a .csv extract in ./tmp.}

\item{rdata}{Optional; Boolean, if TRUE creates an .rdata extract in ./tmp.}

\item{spss}{Optional; Boolean, if TRUE creates a .sav extract in ./tmp.}

\item{limited_dataset}{Optional; Boolean, if TRUE does not perform date-shifting of interview_date or age-capping of interview_age}

\item{skip_prompt}{Logical. If TRUE (default), skips confirmation prompts unless preferences aren't set yet. If FALSE,
prompts for confirmation unless the user has previously chosen to remember their preference.}
}
\value{
Prints the time taken for the data request process.
}
\description{
This function processes requests for clean data sequentially for specified measures.
It makes a request to the NIH NDA API for the named data structures
and runs the associated data remediation routines. It then runs a series of
unit tests to verify that the data quality standards are met.
}
\examples{
\dontrun{
  nda("prl", csv=TRUE)
  nda("rgpts", "kamin", rdata=TRUE)

  # Skip confirmation prompts
  nda("prl", csv=TRUE, skip_prompt=TRUE)
}

}
\author{
Joshua Kenney \href{mailto:joshua.kenney@yale.edu}{joshua.kenney@yale.edu}
}
