% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRda.R
\name{to.rds}
\alias{to.rds}
\title{Create .rds file from a data frame}
\usage{
to.rds(df, df_name = NULL, path = ".", skip_prompt = FALSE)
}
\arguments{
\item{df}{Data frame to be exported to RDS format.}

\item{df_name}{Optional; a custom file name for the saved RDS file.
If not provided, the name of the data frame variable is used.
The function adds the ".rds" extension automatically.}

\item{path}{Character string specifying the directory path where the "tmp" folder
and RDS file should be created. Defaults to the current working directory.}

\item{skip_prompt}{Logical. If TRUE, skips the confirmation prompt. If FALSE (default),
will prompt for confirmation unless the user has previously chosen to remember their preference.}
}
\value{
Invisible TRUE if successful. The function writes an RDS file to the specified path
and prints a message indicating the file's location.
}
\description{
This function exports a given R data frame to an RDS file format.
The resulting file is saved in the "tmp" directory. If a filename
is not specified, the function uses the name of the data frame variable.
The ".rds" extension is appended automatically to the filename.
The function will prompt for confirmation before creating the file,
with an option to remember the user's preference for future calls.
}
\examples{
\dontrun{
# Create a sample data frame
sample_df <- data.frame(
  id = 1:3,
  name = c("Alice", "Bob", "Charlie")
)

# Basic usage with prompt
to.rds(sample_df)

# Custom filename
to.rds(sample_df, "participants_data")

# Skip the confirmation prompt
to.rds(sample_df, skip_prompt = TRUE)

# Save in a different directory
to.rds(sample_df, path = "path/to/project")
}

}
