% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_nas.R
\name{row_nas}
\alias{row_nas}
\alias{row_nas.matrix}
\alias{row_nas.data.frame}
\title{Conditions related to missing values}
\usage{
row_nas(.data, match_type = "none", ...)

\method{row_nas}{matrix}(.data, match_type = "none", ...)

\method{row_nas}{data.frame}(.data, match_type = "none", ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{match_type}{One of ("all", "any", "none", "which_first", "count"). Possibly abbreviated.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{output_class}}{One of ("vector", "list", "data.frame", "matrix"), possibly abbreviated.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
    \item{\code{factor_mode}}{One of ("character", "integer"), possibly abbreviated. If a column is a
factor, this determines whether the operation uses its internal integer values, or the
character values from its levels.}
  }}
}
\description{
Conditions related to missing values
}
\examples{

# any base type supported
row_nas(data.frame(NA, NA_integer_, NA_real_, NA_complex_), "all", output_class = "data.frame")

}
