% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_aqi.R
\name{get_counties}
\alias{get_counties}
\title{Get list of county FIPS codes by providing the state codes, i.e. California = '06'.}
\usage{
get_counties(aqs_api_email, aqs_api_key, state_codes)
}
\arguments{
\item{aqs_api_email}{AQS API email}

\item{aqs_api_key}{AQS API key}

\item{state_codes}{A vector of standard state codes according to the Federal Information Processing Standard Publication.
This is an output of the \code{\link{get_state_code}} function.}
}
\value{
A dataframe of combined, 5 digit state + county FIPS codes ('fips') and their corresponding county names ('name').
}
\description{
Get list of county FIPS codes by providing the state codes, i.e. California = '06'.
}
\note{
The function uses the AQS API to fetch the data from the API endpoints. Use the following service to register as a user:
A verification email will be sent to the email account specified. To register using the email address
create and request this link (Replace \email{myemail@example.com} in the example with your email address.):
(\url{https://aqs.epa.gov/data/api/signup?email=myemail@example.com})
You then need to set the email and the key in the .Renviron file as follows, i.e.
aqs_api_email=\email{myemail@example.com}
aqs_api_key=testkey1234

AQS AQI has request limits and ToS: (\url{https://aqs.epa.gov/aqsweb/documents/data_api.html#terms}). The function intentionally
adds a 10 second delay between each call (per year, per county) but pay attention to the limits as the account may be disabled.
}
\examples{
\dontrun{
aqs_api_email = Sys.getenv('aqs_api_email')
aqs_api_key = Sys.getenv('aqs_api_key')

state_codes <- get_state_code(aqs_api_email = aqs_api_email,
                              aqs_api_key = aqs_api_key,
                              state_names = c('California', 'New York'))
counties <- get_counties(aqs_api_email = aqs_api_email,
                         aqs_api_key = aqs_api_key,
                         state_codes = state_codes)
}
}
