% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_wildfire.R
\name{create_wildfire}
\alias{create_wildfire}
\title{Create US wildfires dataframe from the Kaggle US Wildfire SQLite db}
\usage{
create_wildfire(
  db_name,
  state_abbrev = NULL,
  cols = c("FIRE_NAME", "DISCOVERY_DATE", "CONT_DATE", "STAT_CAUSE_DESCR", "FIRE_SIZE",
    "FIRE_SIZE_CLASS", "LATITUDE", "LONGITUDE", "STATE", "FIPS_CODE", "FIPS_NAME"),
  year_min = 1992,
  year_max = 2015
)
}
\arguments{
\item{db_name}{File path of the SQLite wildfire database.}

\item{state_abbrev}{Abbreviations of the states to retrieve the wildfire data for.}

\item{cols}{Columns to select from the wildfire database. For more info: (\url{https://www.kaggle.com/rtatman/188-million-us-wildfires})}

\item{year_min}{earliest year to pull the air quality data for, starts January 1st.}

\item{year_max}{latest year to pull the air quality data for, ends December 31st.}
}
\value{
A dataframe of wildfires that occurred in the United States.
}
\description{
Create US wildfires dataframe from the Kaggle US Wildfire SQLite db
}
\note{
The function relies on the SQLite db available on Kaggle: (\url{https://www.kaggle.com/rtatman/188-million-us-wildfires})
    Unfortunately, Kaggle API does not support R at this time. Download the '188-million-us-wildfires.zip' file,
    and provide the path to the function as db_name, i.e. \code{db_name = 'data-raw/FPA_FOD_20170508.sqlite'}
}
\examples{
\dontrun{
fires <- create_wildfire(db_name = 'data-raw/FPA_FOD_20170508.sqlite',
                         state_abbrev = c('CA', 'NY'),
                         cols=c('FIRE_NAME', 'DISCOVERY_DATE', 'CONT_DATE',
                                'STAT_CAUSE_DESCR', 'FIRE_SIZE', 'FIRE_SIZE_CLASS',
                                'LATITUDE', 'LONGITUDE', 'STATE', 'FIPS_CODE', 'FIPS_NAME'),
                         year_min = 1992,
                         year_max = 2015)
}

}
