% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{getWikiData}
\alias{getWikiData}
\title{Create a data.frame with Wikidata of a vector of names.}
\usage{
getWikiData(names, language = "en", csv = NULL)
}
\arguments{
\item{names}{A vector consisting of one or more Wikidata's entry (i.e., topic or person).}

\item{language}{The language of the Wikipedia page version. This should consist of an ISO language code (default = "en").}

\item{csv}{A file name to save the results, in which case the only return is a message with the name of the saved file.}
}
\value{
A data frame with personal information of the names or a csv file with the information separated by semicolons.
}
\description{
Create a data.frame with Wikidata of a vector of names.
}
\examples{
## Obtaining information in English Wikidata
\dontrun{
names <- c("William Shakespeare", "Pedro Almodovar")
info <- getWikiData(names)
## Obtaining information in Spanish Wikidata
d <- getWikiData(names, language="es")
}
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
