% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_agriculture.R
\name{wbt_yield_normalization}
\alias{wbt_yield_normalization}
\title{Yield normalization}
\usage{
wbt_yield_normalization(
  input,
  yield_field,
  output,
  standardize = FALSE,
  radius = NULL,
  min_yield = 0,
  max_yield = 99999.9,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input points shapefile.}

\item{yield_field}{Name of the attribute containing yield data.}

\item{output}{Name of the output points shapefile.}

\item{standardize}{Should the yield values be standardized (converted to z-scores) rather than normalized?.}

\item{radius}{Optional search radius, in metres. Only specify this value if you want to calculate locally normalized yield.}

\item{min_yield}{Minimum yield value in output.}

\item{max_yield}{Maximum yield value in output.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool can be used to normalize the yield points for a field.
}
