% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whibo_clustering.R
\name{plot_pairs}
\alias{plot_pairs}
\title{Plot WhiBo Cluster Representatives}
\usage{
plot_pairs(model, data)
}
\arguments{
\item{model}{WhiBo Cluster model.}

\item{data}{Data used for clustering (optional).}
}
\value{
Ploting pairs plot where Cluster representatives are presented with data (if provided).
}
\description{
Plot WhiBo Cluster Representatives
}
\examples{
data <- iris[, 1:4] #Numerical data only

model <- whibo_clustering(data = data, k = 3)
plot_pairs(model) #Ploting Cluster Representatives only

plot_pairs(model, data) #Ploting Cluster Representatives and Data

}
\author{
Sandro Radovanovic \email{sandro.radovanovic@gmail.com}
}
