% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatr-doubles.R
\name{whatr_doubles}
\alias{whatr_doubles}
\title{What are daily doubles?}
\format{a named list
\describe{
\item{round}{The round a clue is chosen.}
\item{col}{The column position left-to-right.}
\item{row}{The row position top-to-bottom.}
\item{i}{The order of clue chosen.}
\item{clue}{The clue read to the contestants.}
\item{score}{The amount won or lost on the wager.}
}}
\usage{
whatr_doubles(game)
}
\arguments{
\item{game}{One of four types of input, all passed to \code{\link[=whatr_html]{whatr_html()}}:
\enumerate{
\item A numeric game ID.
\item Either a 'showgame' or 'showscores' HTML document.
\item A show number character starting with "#".
\item An air date like "yyyy-mm-dd".
}}
}
\value{
a list containing the question indices of the daily doubles
in the first and second rounds
}
\description{
\emph{These} types of clues have no dollar value. Players wager some of their
score before hearing the clue. In the first round, one such clue is present;
in the second round, there are two.
}
\examples{
whatr_doubles(game = 6304)
}
