% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_pbp.R
\name{load_wnba_player_box}
\alias{load_wnba_player_box}
\title{\strong{Load wehoop WNBA player box scores}}
\usage{
load_wnba_player_box(
  seasons = most_recent_wnba_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given WNBA seasons. (Min: 2002)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_wnba_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{tablename}{The name of the player box data table within the database}
}
\value{
Returns a tibble
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
  try(load_wnba_player_box())
}
}
