% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readers.R
\name{read_aws}
\alias{read_aws}
\title{read Amazon CloudFront access logs}
\usage{
read_aws(file)
}
\arguments{
\item{file}{the full path to the AWS file you want to read.}
}
\description{
Amazon CloudFront uses access logs with a standard format described
\href{http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html}{
on their website}. \code{read_aws} reads these files in; due to the Amazon treatment of header lines,
it is capable of organically detecting whether files lack common fields, and compensating for that. See
"Details"
}
\details{
Amazon CloudFront uses tab-separated files with
\href{http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html}{
Amazon-specific fields}. This can be changed by individual CloudFront users, however, to exclude particular fields,
and historically has contained fewer fields than it now does. Luckily, Amazon's insistence on standardisation in field
names means that we can organically detect if fields are missing, and compensate for that before reading in the file.

If no fields are missing, the fields returned will be:

\itemize{
 \item{date:} {the date and time when the request was \emph{completed}}
 \item{time_elapsed:} {the amount of time (in milliseconds) that the connection and fulfilment
 of the request lasted for.}
 \item{edge_location:} {the Amazon edge location that served the request, identified by a three-letter
 code. See the Amazon documentation for more details.}
 \item{bytes_sent:} {a count of the number of bytes sent by the server to the client, including headers,
 to fulfil the request.}
 \item{ip_address:} {the IP address of the client making the request.}
 \item{http_method:} {the HTTP method (POST, GET, etc) used.}
 \item{host:} {the CloudFront host name.}
 \item{path:} {the path to the requested asset.}
 \item{status_code:} {the HTTP status code associated with the request.}
 \item{referer:} {the referer associated with the request.}
 \item{user_agent:} {the user agent of the client that made the request.}
 \item{query:} {the query string associated with the request; if there is no query string,
 this will be a dash.}
 \item{cookie:} {the cookie header from the request, stored as name-value pairs. When no
 cookie header is provided, or it is empty, this will be a dash.}
 \item{result_type:} {the result of the request. This is similar to Squid response codes (
 see \code{\link{read_squid}}) but Amazon-specific; their documentation contains details on
 what each code means.}
 \item{request_id:} {A hashed unique identifier for each request.}
 \item{host_header: }{the host header of the requested asset. While \code{host} will always
 be the CloudFront host name, \code{host_header} contains alternate domain names (or 'CNAMES')
 when the CloudFront distribution is using them}.
 \item{protocol: } {the protocol used in the request (http/https).}
 \item{bytes_received: }{client-to-server bytes, including headers.}
 \item{time_elapsed:} {the time elapsed, in seconds, between the time the request was received and
 the time the server completed responding to it.}
}
}
\examples{
#Read in an example CloudFront file provided with the webreadr package.
data <- read_aws(system.file("extdata/log.aws", package = "webreadr"))
}
\seealso{
\code{\link{read_clf}} for the Common Log Format, \code{\link{read_squid}} and
\code{\link{read_combined}}.
}

