% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_tem.R
\name{draw_tem}
\alias{draw_tem}
\title{Draw template}
\usage{
draw_tem(
  stimuli,
  pt.color = wm_opts("pt.color"),
  pt.alpha = 0.75,
  pt.size = NULL,
  pt.shape = c("circle", "cross", "index"),
  line.color = wm_opts("line.color"),
  line.alpha = 0.5,
  line.size = NULL,
  bg = "image"
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{pt.color, line.color}{line or point color, see \code{\link[=color_conv]{color_conv()}}}

\item{pt.alpha, line.alpha}{transparency (0-1), ignored if color is a hex value with transparency. Set alpha to 0 to omit lines or points.}

\item{pt.size, line.size}{size in pixels (scales to image size if NULL)}

\item{pt.shape}{the shape of the points ("circle", "cross", "index")}

\item{bg}{background color ("image" uses the original image)}
}
\value{
list of stimuli with template images
}
\description{
Visualise a template on an image.
}
\details{
Visualising the index of each point isn't great yet and will overlay
}
\examples{
# get an image with 2 different templates
stimuli <- demo_tems("frl|fpp106")

# default template
draw_tem(stimuli)

\donttest{
# custom template
draw_tem(stimuli, 
         pt.shape = "cross",
         pt.color = "red", 
         pt.alpha = 1,
         pt.size = 15,
         line.color = rgb(0, 0, 0),
         line.alpha = 0.5,
         line.size = 5)

# indexed template
draw_tem(stimuli, 
         pt.shape = "index",
         pt.size = 15, 
         pt.alpha = 1,
         line.alpha = 0)
}
}
\seealso{
Template functions
\code{\link{auto_delin}()},
\code{\link{average_tem}()},
\code{\link{centroid}()},
\code{\link{change_lines}()},
\code{\link{delin}()},
\code{\link{features}()},
\code{\link{get_point}()},
\code{\link{remove_tem}()},
\code{\link{require_tems}()},
\code{\link{same_tems}()},
\code{\link{squash_tem}()},
\code{\link{subset_tem}()},
\code{\link{tem_def}()},
\code{\link{viz_tem_def}()}

Visualisation functions
\code{\link{as_ggplot}()},
\code{\link{gglabel}()},
\code{\link{label}()},
\code{\link{mlabel}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_rows}()},
\code{\link{plot_stim}()}
}
\concept{tem}
\concept{viz}
