% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather.R
\name{weather_dl}
\alias{weather_dl}
\alias{weather}
\title{Download weather data from Environment Canada}
\usage{
weather_dl(station_ids, start = NULL, end = NULL, interval = "hour",
  trim = TRUE, format = TRUE, string_as = NA, tz_disp = NULL,
  stn = weathercan::stations, url = NULL, encoding = "UTF-8",
  list_col = FALSE, verbose = FALSE, quiet = FALSE)
}
\arguments{
\item{station_ids}{Numeric/Character. A vector containing the ID(s) of the
station(s) you wish to download data from. See the \code{\link{stations}}
data frame or the \code{\link{stations_search}} function to find IDs.}

\item{start}{Date/Character. The start date of the data in YYYY-MM-DD format
(applies to all stations_ids). Defaults to start of range.}

\item{end}{Date/Character. The end date of the data in YYYY-MM-DD format
(applies to all station_ids). Defaults to end of range.}

\item{interval}{Character. Interval of the data, one of "hour", "day",
"month".}

\item{trim}{Logical. Trim missing values from the start and end of the
weather dataframe. Only applies if `format = TRUE`}

\item{format}{Logical. If TRUE, formats data for immediate use. If FALSE,
returns data exactly as downloaded from Environment and Climate Change
Canada. Useful for dealing with changes by Environment Canada to the format
of data downloads.}

\item{string_as}{Character. What value to replace character strings in a
numeric measurement with. See Details.}

\item{tz_disp}{Character. What timezone to display times in (must be one of
\code{OlsonNames()}).}

\item{stn}{Data frame. The \code{stations} data frame to use. Will use the
one included in the package unless otherwise specified.}

\item{url}{Character. Url from which to grab the weather data. If NULL uses
default url (see details)}

\item{encoding}{Character. Text encoding for download.}

\item{list_col}{Logical. Return data as nested data set? Defaults to FALSE.
Only applies if `format = TRUE`}

\item{verbose}{Logical. Include progress messages}

\item{quiet}{Logical. Suppress all messages (including messages regarding
missing data, etc.)}
}
\value{
A tibble with station ID, name and weather data.
}
\description{
Downloads data from Environment Canada for one or more stations. For details
and units, see the glossary vignette (\code{vignette("glossary", package =
"weathercan")}) or the glossary online
\url{http://climate.weather.gc.ca/glossary_e.html}.
}
\details{
Data can be returned 'raw' (format = FALSE) or can be formatted.
  Formatting transforms dates/times to date/time class, renames columns, and
  converts data to numeric where possible. If character strings are contained
  in traditionally numeric fields (e.g., weather speed may have values such
  as "< 30"), they can be replaced with a character specified by `string_as`.
  The default is NA. Formatting also replaces data associated with certain
  flags with NA (M = Missing).

  Start and end date can be specified, but if not, it will default to the
  start and end date of the range (this could result in downloading a lot of
  data!).

  Times are returned as the Etc/GMT offset timezone corresponding to the
  location. This does not include daylight savings. However, for
  compatibility with other data sets, timezones can be converted by
  specifying the desired timezone in `tz_disp`.

  By default, downloads from
  "http://climate.weather.gc.ca/climate_data/bulk_data_e.html"

  Data is downloaded from ECCC as a series of files which are then bound
  together. Each file corresponds to a different month, or year, depending on
  the interval. Metadata (station name, lat, lon, elevation, etc.) is
  extracted from the start of the most recent file (i.e. most recent dates)
  for a given station. Note that important data (i.e. station name, lat, lon)
  is unlikely to change between files (i.e. dates), but some data may or may
  not be available depending on the date of the file (e.g., station operator
  was added as of April 1st 2018, so will be in all data which includes dates
  on or after April 2018).
}
\examples{

\donttest{
kam <- weather_dl(station_ids = 51423,
                  start = "2016-01-01", end = "2016-02-15")
}

stations_search("Kamloops A$", interval = "hour")
stations_search("Prince George Airport", interval = "hour")
\donttest{
kam.pg <- weather_dl(station_ids = c(48248, 51423),
                     start = "2016-01-01", end = "2016-02-15")

library(ggplot2)

ggplot(data = kam.pg, aes(x = time, y = temp,
                          group = station_name,
                          colour = station_name)) +
       geom_line()
}

}
