% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/every_other.R
\name{every_other}
\alias{every_other}
\title{Select every other (nth) element from a vector}
\usage{
every_other(x, n = 2, start = 1, fill = NULL)
}
\arguments{
\item{x}{Vector to select (remove) elements from}

\item{n}{Numeric value for the number of elements to skip. Default is 2, i.e. skips every second element}

\item{start}{Numeric value to indicate which element of the vector to commence from.}

\item{fill}{Character string to be used in place of skipped element. By default is \code{NULL} and hence skipped elements are removed rather than replaced.}
}
\value{
Vector with elements removed
}
\description{
Select every other (nth) element from a vector
}
\examples{
every_other(x = letters)
every_other(LETTERS, n = 3, start = 6)
every_other(x = letters, fill = "")
}
