% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcorr.R
\name{xcorr}
\alias{xcorr}
\title{Spectrogram cross-correlation}
\source{
H. Khanna, S.L.L. Gaunt & D.A. McCallum (1997). Digital spectrographic 
cross-correlation: tests of sensitivity. Bioacoustics 7(3): 209-234
}
\usage{
xcorr(X, wl =512, frange= NULL, ovlp=90, dens=0.9, bp= NULL, wn='hanning', 
cor.method = "pearson", parallel = 1)
}
\arguments{
\item{X}{Data frame containing columns for sound files (sound.files), 
selection number (selec), and start and end time of signal (start and end).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{frange}{A numeric vector of length 2 setting the upper and lower frequency limits (in kHz) 
in which to compare the signals. If not provided (\code{NULL}) the \code{\link{dfts}} function is used internally to define
the higher and lower dominant frequency in the signals to be analyzed. This method is more adequate for pure tone
signals. Default is \code{NULL}.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 90. High values of ovlp 
slow down the function but produce more accurate results.}

\item{dens}{Numeric vector of length 1 specifying the approximate density of points in which to sample amplitude. 
See \code{\link[monitoR]{makeTemplate}}. Deafult is 0.9.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) in which to detect dominant frequency. 
Only applied when frange is \code{NULL}. Default is \code{NULL}.}

\item{wn}{A character vector of length 1 specifying the window name as in \code{\link[seewave]{ftwindow}}.}

\item{cor.method}{A character vector of length 1 specifying the correlation method as in \code{\link[stats]{cor}}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (e.i. no parallel computing).
For windows OS the \code{warbleR} from github to run parallel.}
}
\value{
A list that includes 1) a data frame with the correlation statistic for each "sliding" step, 2) a matrix with 
the maximum (peak) correlation for each pairwise comparison, and 3) the frequency range.
}
\description{
\code{xcorr} Estimates the similarity of two spectrograms by means of cross-correlation
}
\details{
This function calculates the pairwise similarity of multiple signals by means of spectrogram cross-correlation.
This method "slides" one spectrogram over the other calculating a correlation of the amplitude values at each step.
The function runs pairwise cross-correlations on several signals and returns a list including the correlation statistic
for each "sliding" step as well as the maximum (peak) correlation for each pairwise comparison. To accomplish this the margins
of the signals are expanded by half the duration of the signal both before and after the provided time coordinates. This function
is a modified version of the \code{\link[monitoR]{corMatch}} and \code{\link[monitoR]{makeTemplate}} 
from the awesome R package `monitoR`.
}
\examples{
\dontrun{
#First set temporal working directory
setwd(tempdir())

#load data
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4","manualoc.df"))
writeWave(Phae.long1, "Phae.long1.wav") #save sound files
writeWave(Phae.long2, "Phae.long2.wav")
writeWave(Phae.long3, "Phae.long3.wav")
writeWave(Phae.long4, "Phae.long4.wav")

xcor<-xcorr(X = manualoc.df, wl =300, frange= c(2, 9), ovlp=90, 
dens=1, wn='hanning', cor.method = "pearson") 

}
}
\author{
Marcelo Araya-Salas \email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{xcorr.graph}}
}

